#!/bin/sh

# panic: Assertion mtx_unowned(m) failed at ../../../kern/kern_mutex.c:1179
# cpuid = 2
# time = 1581180711
# KDB: stack backtrace:
# db_trace_self_wrapper() at db_trace_self_wrapper+0x2b/frame 0xfffffe00e57958c0
# vpanic() at vpanic+0x185/frame 0xfffffe00e5795920
# panic() at panic+0x43/frame 0xfffffe00e5795980
# _mtx_destroy() at _mtx_destroy+0x4c/frame 0xfffffe00e57959a0
# solisten_proto() at solisten_proto+0xdb/frame 0xfffffe00e5795a00
# tcp6_usr_listen() at tcp6_usr_listen+0x16d/frame 0xfffffe00e5795a60
# solisten() at solisten+0x42/frame 0xfffffe00e5795a80
# kern_listen() at kern_listen+0x80/frame 0xfffffe00e5795ac0
# amd64_syscall() at amd64_syscall+0x2f1/frame 0xfffffe00e5795bf0
# fast_syscall_common() at fast_syscall_common+0x101/frame 0xfffffe00e5795bf0

[ `uname -p` = "i386" ] && exit 0

. ../default.cfg
cat > /tmp/syzkaller4.c <<EOF
// https://syzkaller.appspot.com/bug?id=db195d1b0b8ca408a46f301eba33f9457bd2d429
// autogenerated by syzkaller (https://github.com/google/syzkaller)

#define _GNU_SOURCE

#include <sys/types.h>

#include <errno.h>
#include <pthread.h>
#include <pwd.h>
#include <signal.h>
#include <stdarg.h>
#include <stdbool.h>
#include <stdint.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/endian.h>
#include <sys/syscall.h>
#include <sys/wait.h>
#include <time.h>
#include <unistd.h>

static void kill_and_wait(int pid, int* status)
{
  kill(pid, SIGKILL);
  while (waitpid(-1, status, 0) != pid) {
  }
}

static void sleep_ms(uint64_t ms)
{
  usleep(ms * 1000);
}

static uint64_t current_time_ms(void)
{
  struct timespec ts;
  if (clock_gettime(CLOCK_MONOTONIC, &ts))
    exit(1);
  return (uint64_t)ts.tv_sec * 1000 + (uint64_t)ts.tv_nsec / 1000000;
}

static void thread_start(void* (*fn)(void*), void* arg)
{
  pthread_t th;
  pthread_attr_t attr;
  pthread_attr_init(&attr);
  pthread_attr_setstacksize(&attr, 128 << 10);
  int i;
  for (i = 0; i < 100; i++) {
    if (pthread_create(&th, &attr, fn, arg) == 0) {
      pthread_attr_destroy(&attr);
      return;
    }
    if (errno == EAGAIN) {
      usleep(50);
      continue;
    }
    break;
  }
  exit(1);
}

typedef struct {
  pthread_mutex_t mu;
  pthread_cond_t cv;
  int state;
} event_t;

static void event_init(event_t* ev)
{
  if (pthread_mutex_init(&ev->mu, 0))
    exit(1);
  if (pthread_cond_init(&ev->cv, 0))
    exit(1);
  ev->state = 0;
}

static void event_reset(event_t* ev)
{
  ev->state = 0;
}

static void event_set(event_t* ev)
{
  pthread_mutex_lock(&ev->mu);
  if (ev->state)
    exit(1);
  ev->state = 1;
  pthread_mutex_unlock(&ev->mu);
  pthread_cond_broadcast(&ev->cv);
}

static void event_wait(event_t* ev)
{
  pthread_mutex_lock(&ev->mu);
  while (!ev->state)
    pthread_cond_wait(&ev->cv, &ev->mu);
  pthread_mutex_unlock(&ev->mu);
}

static int event_isset(event_t* ev)
{
  pthread_mutex_lock(&ev->mu);
  int res = ev->state;
  pthread_mutex_unlock(&ev->mu);
  return res;
}

static int event_timedwait(event_t* ev, uint64_t timeout)
{
  uint64_t start = current_time_ms();
  uint64_t now = start;
  pthread_mutex_lock(&ev->mu);
  for (;;) {
    if (ev->state)
      break;
    uint64_t remain = timeout - (now - start);
    struct timespec ts;
    ts.tv_sec = remain / 1000;
    ts.tv_nsec = (remain % 1000) * 1000 * 1000;
    pthread_cond_timedwait(&ev->cv, &ev->mu, &ts);
    now = current_time_ms();
    if (now - start > timeout)
      break;
  }
  int res = ev->state;
  pthread_mutex_unlock(&ev->mu);
  return res;
}

struct thread_t {
  int created, call;
  event_t ready, done;
};

static struct thread_t threads[16];
static void execute_call(int call);
static int running;

static void* thr(void* arg)
{
  struct thread_t* th = (struct thread_t*)arg;
  for (;;) {
    event_wait(&th->ready);
    event_reset(&th->ready);
    execute_call(th->call);
    __atomic_fetch_sub(&running, 1, __ATOMIC_RELAXED);
    event_set(&th->done);
  }
  return 0;
}

static void execute_one(void)
{
  int i, call, thread;
  int collide = 0;
again:
  for (call = 0; call < 19; call++) {
    for (thread = 0; thread < (int)(sizeof(threads) / sizeof(threads[0]));
         thread++) {
      struct thread_t* th = &threads[thread];
      if (!th->created) {
        th->created = 1;
        event_init(&th->ready);
        event_init(&th->done);
        event_set(&th->done);
        thread_start(thr, th);
      }
      if (!event_isset(&th->done))
        continue;
      event_reset(&th->done);
      th->call = call;
      __atomic_fetch_add(&running, 1, __ATOMIC_RELAXED);
      event_set(&th->ready);
      if (collide && (call % 2) == 0)
        break;
      event_timedwait(&th->done, 45);
      break;
    }
  }
  for (i = 0; i < 100 && __atomic_load_n(&running, __ATOMIC_RELAXED); i++)
    sleep_ms(1);
  if (!collide) {
    collide = 1;
    goto again;
  }
}

static void execute_one(void);

#define WAIT_FLAGS 0

static void loop(void)
{
  int iter __unused;
  for (iter = 0;; iter++) {
    int pid = fork();
    if (pid < 0)
      exit(1);
    if (pid == 0) {
      execute_one();
      exit(0);
    }
    int status = 0;
    uint64_t start = current_time_ms();
    for (;;) {
      if (waitpid(-1, &status, WNOHANG | WAIT_FLAGS) == pid)
        break;
      sleep_ms(1);
      if (current_time_ms() - start < 5 * 1000)
        continue;
      kill_and_wait(pid, &status);
      break;
    }
  }
}

uint64_t r[6] = {0x0, 0xffffffffffffffff, 0x0, 0xffffffffffffffff,
                 0x0, 0xffffffffffffffff};

void execute_call(int call)
{
  intptr_t res;
  switch (call) {
  case 0:
    *(uint32_t*)0x20000040 = 0x284002b0;
    *(uint32_t*)0x20000044 = 0;
    *(uint32_t*)0x20000048 = 0;
    *(uint32_t*)0x2000004c = 0;
    *(uint32_t*)0x20000050 = 0;
    *(uint32_t*)0x20000054 = 0;
    *(uint16_t*)0x20000058 = 0;
    *(uint16_t*)0x2000005a = 0;
    *(uint64_t*)0x20000060 = 0;
    *(uint64_t*)0x20000068 = 0;
    *(uint64_t*)0x20000070 = 0;
    *(uint64_t*)0x20000078 = 0;
    *(uint64_t*)0x20000080 = 0;
    *(uint64_t*)0x20000088 = 0;
    *(uint64_t*)0x20000090 = 0;
    syscall(SYS___semctl, 0, 0ul, 0xaul, 0x20000040ul);
    break;
  case 1:
    memcpy(
        (void*)0x20000340,
        "\x82\x02\xf3\x89\x9c\x53\x3e\x9e\x79\x9b\xd7\xc7\x3c\xcc\x8e\xf9\xba"
        "\xb3\x80\xca\x99\xbc\x30\xf1\x8e\x7c\xb0\xc5\x3f\xd6\xa9\xe6\xc6\xa8"
        "\xa8\x85\x82\x5b\xdf\x69\xb0\xb9\xed\x55\x59\xd8\x3d\x18\x64\x0d\x49"
        "\xdd\x0c\x5b\xba\x14\x0e\xe4\x61\xce\xcf\x6c\x04\x6a\xa1\xda\xa6\x9a"
        "\x50\xf8\xa5\xbf\x52\xc2\x63\xf1\x48\xad\xb2\x3e\x5b\x74\xd4\xd3\xe2"
        "\x77\x4e\xe8\xef\x92\x6d\x3e\xf6\x35\x76\x60\x9b\x83\xfd\xbc\x00\x45"
        "\xd8\x01\x38\x8b\x7b\x9f\x82\x1e\xf2\xe6\x42\xd3\x73\x00\x00\xc4\x05"
        "\xc0\xc2\x1a\x82\xc5\x8e\x64\x2d\x07\x86\x09\x4f\xb0\x60\x2a\x5b\xfd"
        "\x33\x73\x24\x41\xb5\xaa\x99\xd6\xdf\xbe\x06\xc7\x27\x48\x7e\x13\xfb"
        "\x57\xd6\x2f\xcb\x0c\xda\x92\xcc\xc7\x0f\xb4\x6f\x95\xcb\x5d\x0c\x28"
        "\x93\x70\xbc\x25\x88\x76\x2f\xd7\x86\x9e\x5e\x03\xfa\x9c\x68\xde\x52"
        "\x23\xc5\xae\xa1\x1c\x58\x79\x1a\x6f\xfa\x52\x31\xfc\x2b\xd5\x33\x3d"
        "\x49\x60\x80\xa0\x31\x16\x7e\xa5\xd5\x09\x94\x53\x1e\x3b\x56\x3f\x1e"
        "\x4d\x95\x76\x44\x9d\x59\x7a\x2d\xbc\xea\xe3\x26\x0d\xf6\x68\xee\xba"
        "\xc3\xbb\x9f\xb6\xf1\xa2\x44\xc2\x96\xd5\xdc\xc4\x1c\xa2\xaf\xeb\x92"
        "\x4e\xaf\xfc\x1d\x5d\xaf\x30\x9b\x0b\xfd\x19\x1c\x40\xf9\xd0\x0d\xf5"
        "\x15\x94\xb7\xe9",
        276);
    syscall(SYS_connect, -1, 0x20000340ul, 0x10ul);
    break;
  case 2:
    res = syscall(SYS_semget, 0ul, 0ul, 0x284ul);
    if (res != -1)
      r[0] = res;
    break;
  case 3:
    res = syscall(SYS_socket, 0x1cul, 1ul, 0ul);
    if (res != -1)
      r[1] = res;
    break;
  case 4:
    syscall(SYS_listen, r[1], 0);
    break;
  case 5:
    res = syscall(SYS_fstat, r[1], 0x20000080ul);
    if (res != -1)
      r[2] = *(uint32_t*)0x200000a0;
    break;
  case 6:
    *(uint32_t*)0x20000180 = 0x2840029c;
    *(uint32_t*)0x20000184 = 0;
    *(uint32_t*)0x20000188 = 0;
    *(uint32_t*)0x2000018c = 0;
    *(uint32_t*)0x20000190 = r[2];
    *(uint32_t*)0x20000194 = 0;
    *(uint16_t*)0x20000198 = 0;
    *(uint16_t*)0x2000019a = 0;
    *(uint64_t*)0x200001a0 = 0;
    *(uint64_t*)0x200001a8 = 0;
    *(uint64_t*)0x200001b0 = 0;
    *(uint64_t*)0x200001b8 = 0;
    *(uint64_t*)0x200001c0 = 0;
    *(uint64_t*)0x200001c8 = 0;
    *(uint64_t*)0x200001d0 = 0;
    syscall(SYS___semctl, r[0], 0ul, 0xaul, 0x20000180ul);
    break;
  case 7:
    res = syscall(SYS_socket, 0x1cul, 1ul, 0x84ul);
    if (res != -1)
      r[3] = res;
    break;
  case 8:
    syscall(SYS_connect, r[3], 0ul, 0ul);
    break;
  case 9:
    syscall(SYS_fcntl, r[3], 5ul, 0);
    break;
  case 10:
    syscall(SYS_getresuid, 0x20000040ul, 0ul, 0ul);
    break;
  case 11:
    syscall(SYS___semctl, 0, 0ul, 0xaul, 0ul);
    break;
  case 12:
    syscall(SYS___semctl, 0, 0ul, 1ul, 0ul);
    break;
  case 13:
    res = syscall(SYS_semget, 0ul, 0ul, 0x284ul);
    if (res != -1)
      r[4] = res;
    break;
  case 14:
    syscall(SYS_freebsd11_fstat, -1, 0ul);
    break;
  case 15:
    syscall(SYS___semctl, r[4], 0ul, 1ul, 0ul);
    break;
  case 16:
    res = syscall(SYS_socket, 0x1cul, 1ul, 0ul);
    if (res != -1)
      r[5] = res;
    break;
  case 17:
    syscall(SYS_listen, r[5], 0);
    break;
  case 18:
    syscall(SYS_fstat, r[5], 0ul);
    break;
  }
}
int main(void)
{
  syscall(SYS_mmap, 0x20000000ul, 0x1000000ul, 3ul, 0x1012ul, -1, 0ul);
  loop();
  return 0;
}
EOF
mycc -o /tmp/syzkaller4 -Wall -Wextra -O2 /tmp/syzkaller4.c -lpthread ||
    exit 1

(cd /tmp; timeout 5m ./syzkaller4)

rm -f /tmp/syzkaller4 /tmp/syzkaller4.c
exit 0
