/*
 * Decompiled with CFR 0.152.
 */
package com.sun.prodreg.core;

import com.sun.prodreg.core.ComponentReference;
import com.sun.prodreg.core.ComponentType;
import com.sun.prodreg.core.Registry;
import com.sun.prodreg.core.RegistryQuery;
import com.sun.prodreg.util.Localizer;
import com.sun.prodreg.util.Utils;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Vector;

public class ComponentDescription
extends ComponentReference
implements Serializable,
Cloneable {
    private String uniqueName = null;
    private Hashtable displayNames = null;
    private ComponentReference parent = null;
    private ComponentReference[] children = null;
    private ComponentType componentType = null;
    private String location = null;
    private String uninstaller = null;
    private String vendor = null;
    private Vector requiredComponents = null;
    private Vector dependentComponents = null;
    private Vector backwardCompatible = null;
    private Hashtable data = null;

    public ComponentDescription() {
        this.setComponentType(new ComponentType("component"));
    }

    public ComponentDescription(String id) {
        this();
        this.setID(id);
    }

    public void addChild(ComponentReference child) {
        Vector<ComponentReference> childVector = new Vector<ComponentReference>();
        boolean containsChild = false;
        if (this.children != null) {
            int i = 0;
            while (i < this.children.length) {
                ComponentReference c = this.children[i];
                if (this.equalsReference(c, child)) {
                    containsChild = true;
                }
                childVector.addElement(this.children[i]);
                ++i;
            }
        }
        if (!containsChild) {
            childVector.addElement(child);
        }
        ComponentReference[] childArray = null;
        if (childVector.size() > 0) {
            childArray = new ComponentReference[childVector.size()];
            int i = 0;
            while (i < childArray.length) {
                childArray[i] = (ComponentReference)childVector.elementAt(i);
                ++i;
            }
        }
        this.children = childArray;
    }

    public boolean addCompatibleVersion(String version) {
        if (version != null) {
            if (this.backwardCompatible == null) {
                this.backwardCompatible = new Vector();
            }
            if (!this.backwardCompatible.contains(version)) {
                this.backwardCompatible.addElement(version);
            }
            return true;
        }
        return false;
    }

    public boolean addDependentComponent(ComponentReference dependentComponent) {
        Vector<ComponentReference> dependentComponents = this.getDependentComponents();
        boolean containsChild = false;
        if (dependentComponents == null) {
            dependentComponents = new Vector<ComponentReference>();
        }
        int i = 0;
        while (i < dependentComponents.size()) {
            ComponentReference c = (ComponentReference)dependentComponents.elementAt(i);
            if (this.equalsReference(c, dependentComponent)) {
                containsChild = true;
            }
            ++i;
        }
        if (!containsChild) {
            dependentComponents.addElement(dependentComponent);
            this.setDependentComponents(dependentComponents);
        }
        return true;
    }

    public boolean addRequiredComponent(ComponentReference requiredComponent) {
        Vector<ComponentReference> requiredComponents = this.getRequiredComponents();
        boolean containsChild = false;
        if (requiredComponents == null) {
            requiredComponents = new Vector<ComponentReference>();
        }
        int i = 0;
        while (i < requiredComponents.size()) {
            ComponentReference c = (ComponentReference)requiredComponents.elementAt(i);
            if (this.equalsReference(c, requiredComponent)) {
                containsChild = true;
            }
            ++i;
        }
        if (!containsChild) {
            requiredComponents.addElement(requiredComponent);
            this.setRequiredComponents(requiredComponents);
        }
        return true;
    }

    public synchronized Object clone() {
        Enumeration keys;
        ComponentDescription c = new ComponentDescription();
        c.setID(this.getID());
        c.setInstance(this.getInstance());
        c.setVersion(this.getVersion());
        c.setUniqueName(this.getUniqueName());
        if (this.displayNames != null) {
            keys = this.displayNames.keys();
            while (keys.hasMoreElements()) {
                String language = (String)keys.nextElement();
                String displayName = (String)this.displayNames.get(language);
                c.setDisplayName(language, displayName);
            }
        }
        if (this.parent != null) {
            c.setParent((ComponentReference)this.parent.clone());
        }
        if (this.children != null) {
            int i = 0;
            while (i < this.children.length) {
                c.addChild((ComponentReference)this.children[i].clone());
                ++i;
            }
        }
        if (this.componentType != null) {
            c.setComponentType(this.componentType);
        }
        c.setLocation(this.location);
        c.setUninstaller(this.uninstaller);
        c.setVendor(this.vendor);
        if (this.requiredComponents != null) {
            Enumeration rcomps = this.requiredComponents.elements();
            while (rcomps.hasMoreElements()) {
                ComponentReference rcomp = (ComponentReference)rcomps.nextElement();
                c.addRequiredComponent((ComponentReference)rcomp.clone());
            }
        }
        if (this.dependentComponents != null) {
            Enumeration dcomps = this.dependentComponents.elements();
            while (dcomps.hasMoreElements()) {
                ComponentReference dcomp = (ComponentReference)dcomps.nextElement();
                c.addDependentComponent((ComponentReference)dcomp.clone());
            }
        }
        if (this.backwardCompatible != null) {
            Enumeration versions = this.backwardCompatible.elements();
            while (versions.hasMoreElements()) {
                String version = (String)versions.nextElement();
                c.addCompatibleVersion(version);
            }
        }
        if (this.data != null) {
            keys = this.data.keys();
            while (keys.hasMoreElements()) {
                String key = (String)keys.nextElement();
                String value = (String)this.data.get(key);
                c.setData(key, value);
            }
        }
        return c;
    }

    public ComponentDescription copy() {
        return (ComponentDescription)this.clone();
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof ComponentDescription)) {
            return false;
        }
        ComponentDescription comp = (ComponentDescription)obj;
        if (!Utils.objectsEqual(this.getID(), comp.getID())) {
            return false;
        }
        if (this.getInstance() != comp.getInstance()) {
            return false;
        }
        if (this.isDamaged() != comp.isDamaged()) {
            return false;
        }
        if (!Utils.objectsEqual(this.getVersion(), comp.getVersion())) {
            return false;
        }
        if (!Utils.objectsEqual(this.getUniqueName(), comp.getUniqueName())) {
            return false;
        }
        if (!Utils.hashtablesEqual(this.displayNames, comp.getDisplayNames())) {
            return false;
        }
        if (!Utils.objectsEqual(this.getParent(), comp.getParent())) {
            return false;
        }
        if (!Utils.objectsEqual(this.getChildren(), comp.getChildren())) {
            return false;
        }
        if (!Utils.objectsEqual(this.getComponentType(), comp.getComponentType())) {
            return false;
        }
        if (!Utils.objectsEqual(this.getLocation(), comp.getLocation())) {
            return false;
        }
        if (!Utils.objectsEqual(this.getUninstaller(), comp.getUninstaller())) {
            return false;
        }
        if (!Utils.objectsEqual(this.getVendor(), comp.getVendor())) {
            return false;
        }
        if (!Utils.vectorsEqual(this.getRequiredComponents(), comp.getRequiredComponents())) {
            return false;
        }
        if (!Utils.vectorsEqual(this.getDependentComponents(), comp.getDependentComponents())) {
            return false;
        }
        if (!Utils.objectsEqual(this.getCompatibleVersions(), comp.getCompatibleVersions())) {
            return false;
        }
        return Utils.hashtablesEqual(this.data, comp.getData());
    }

    private boolean equalsReference(ComponentReference c1, ComponentReference c2) {
        if (c1 == c2) {
            return true;
        }
        return c1 != null && c2 != null && c1.getID().equals(c2.getID()) && c1.getInstance() == c2.getInstance();
    }

    public boolean equivalent(ComponentDescription comp) {
        if (this.getID() != null && !this.getID().equals(comp.getID()) || this.getID() == null && comp.getVersion() != null) {
            return false;
        }
        if (this.getInstance() != comp.getInstance()) {
            return false;
        }
        if (this.getVersion() != null && !this.getVersion().equals(comp.getVersion()) || this.getVersion() == null && comp.getVersion() != null) {
            return false;
        }
        if (this.uniqueName != null && !this.uniqueName.equals(comp.getUniqueName()) || this.uniqueName == null && comp.getUniqueName() != null) {
            return false;
        }
        if (this.parent != null && !this.parent.equals(comp.getParent()) || this.parent == null && comp.getParent() != null) {
            return false;
        }
        if (this.componentType != null && !this.componentType.equals(comp.getComponentType()) || this.componentType == null & comp.getComponentType() != null) {
            return false;
        }
        if (this.location != null && !this.location.equals(comp.getLocation()) || this.location == null && comp.getLocation() != null) {
            return false;
        }
        if (this.uninstaller != null && !this.uninstaller.equals(comp.getUninstaller()) || this.uninstaller == null && comp.getUninstaller() != null) {
            return false;
        }
        if (this.requiredComponents == null && comp.getRequiredComponents() != null) {
            return false;
        }
        return this.dependentComponents != null || comp.getDependentComponents() == null;
    }

    public ComponentReference[] getChildren() {
        return this.children;
    }

    public synchronized ComponentDescription[] getChildren(Registry registry) {
        if (this.children != null) {
            Vector<ComponentReference> childVector = new Vector<ComponentReference>();
            int i = 0;
            while (i < this.children.length) {
                RegistryQuery query = new RegistryQuery();
                query.setID(this.children[i].getID());
                query.setInstance(this.children[i].getInstance());
                try {
                    ComponentDescription child = registry.getComponent(query);
                    childVector.addElement(child);
                }
                catch (Exception exception) {
                    childVector.addElement(this.children[i]);
                }
                ++i;
            }
            ComponentDescription[] childrenArray = new ComponentDescription[childVector.size()];
            int i2 = 0;
            while (i2 < childrenArray.length) {
                childrenArray[i2] = (ComponentDescription)childVector.elementAt(i2);
                ++i2;
            }
            return childrenArray;
        }
        return null;
    }

    public String[] getCompatibleVersions() {
        if (this.backwardCompatible == null) {
            return null;
        }
        String[] versions = new String[this.backwardCompatible.size()];
        int index = 0;
        while (index < versions.length) {
            versions[index] = (String)this.backwardCompatible.elementAt(index);
            ++index;
        }
        return versions;
    }

    public ComponentType getComponentType() {
        return this.componentType;
    }

    public Hashtable getData() {
        if (this.data != null) {
            return (Hashtable)this.data.clone();
        }
        return null;
    }

    public String getData(String key) {
        if (this.data != null) {
            return (String)this.data.get(key);
        }
        return null;
    }

    public Vector getDependentComponents() {
        return this.dependentComponents;
    }

    public String[] getDisplayLanguages() {
        if (this.displayNames != null) {
            String[] languages = new String[this.displayNames.size()];
            Enumeration e = this.displayNames.keys();
            int i = 0;
            while (e.hasMoreElements()) {
                languages[i++] = (String)e.nextElement();
            }
            return languages;
        }
        return new String[0];
    }

    public String getDisplayName() {
        Locale def = Locale.getDefault();
        String str = this.getDisplayName(Localizer.localeName(def));
        if (str == null) {
            str = this.getDisplayName("en");
        }
        return str;
    }

    public String getDisplayName(String language) {
        if (this.displayNames != null) {
            String nm = (String)this.displayNames.get(language);
            return nm;
        }
        return null;
    }

    public Hashtable getDisplayNames() {
        return this.displayNames;
    }

    public String getLocation() {
        return this.location;
    }

    public ComponentReference getParent() {
        return this.parent;
    }

    public Vector getRequiredComponents() {
        return this.requiredComponents;
    }

    public String getUninstaller() {
        return this.uninstaller;
    }

    public String getUniqueName() {
        return this.uniqueName;
    }

    public String getVendor() {
        return this.vendor;
    }

    public boolean isDamaged() {
        String dam = this.getData("isDamaged");
        return dam != null && dam.equalsIgnoreCase("true");
    }

    public void removeChild(ComponentReference child) {
        Vector<ComponentReference> childVector = new Vector<ComponentReference>();
        int childIndex = -1;
        if (this.children != null) {
            int i = 0;
            while (i < this.children.length) {
                ComponentReference c = this.children[i];
                if (this.equalsReference(c, child)) {
                    childIndex = i;
                }
                childVector.addElement(this.children[i]);
                ++i;
            }
        }
        if (childIndex >= 0) {
            childVector.removeElementAt(childIndex);
        }
        ComponentReference[] childArray = null;
        if (childVector.size() > 0) {
            childArray = new ComponentReference[childVector.size()];
            int i = 0;
            while (i < childArray.length) {
                childArray[i] = (ComponentReference)childVector.elementAt(i);
                ++i;
            }
        }
        this.children = childArray;
    }

    public boolean removeCompatibleVersion(String version) {
        if (version != null && this.backwardCompatible != null && this.backwardCompatible.contains(version)) {
            this.backwardCompatible.removeElement(version);
        }
        return true;
    }

    public boolean removeDependentComponent(ComponentReference dependentComponent) {
        Vector dependentComponents = this.getDependentComponents();
        int childIndex = -1;
        if (dependentComponents != null) {
            int i = 0;
            while (i < dependentComponents.size()) {
                ComponentReference c = (ComponentReference)dependentComponents.elementAt(i);
                if (this.equalsReference(c, dependentComponent)) {
                    childIndex = i;
                }
                ++i;
            }
            if (childIndex >= 0) {
                dependentComponents.removeElementAt(childIndex);
            }
        }
        return true;
    }

    public boolean removeRequiredComponent(ComponentReference requiredComponent) {
        Vector requiredComponents = this.getRequiredComponents();
        int childIndex = -1;
        if (requiredComponents != null) {
            int i = 0;
            while (i < requiredComponents.size()) {
                ComponentReference c = (ComponentReference)requiredComponents.elementAt(i);
                if (this.equalsReference(c, requiredComponent)) {
                    childIndex = i;
                }
                ++i;
            }
            if (childIndex >= 0) {
                requiredComponents.removeElementAt(childIndex);
            }
        }
        return true;
    }

    public void setComponentType(ComponentType componentType) {
        this.componentType = componentType;
    }

    public boolean setData(String key, String value) {
        if (this.data == null) {
            this.data = new Hashtable();
        }
        this.data.put(key, value);
        return true;
    }

    public void setDependentComponents(Vector dependentComponents) {
        this.dependentComponents = dependentComponents;
    }

    public void setDisplayName(String displayName) {
        this.setDisplayName("en", displayName);
    }

    public void setDisplayName(String language, String displayName) {
        if (this.displayNames == null) {
            this.displayNames = new Hashtable();
        }
        this.displayNames.put(language, displayName);
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public void setParent(ComponentReference parent) {
        this.parent = parent;
    }

    public void setRequiredComponents(Vector requiredComponents) {
        this.requiredComponents = requiredComponents;
    }

    public void setUninstaller(String uninstaller) {
        this.uninstaller = uninstaller;
    }

    public void setUniqueName(String uniqueName) {
        this.uniqueName = uniqueName;
    }

    public void setVendor(String vendor) {
        this.vendor = vendor;
    }

    public String toString() {
        String outputString = "[";
        outputString = String.valueOf(outputString) + "id=" + this.getID();
        outputString = String.valueOf(outputString) + " instance=" + this.getInstance() + ", ";
        outputString = String.valueOf(outputString) + " damaged=" + this.isDamaged() + ", ";
        outputString = String.valueOf(outputString) + " uniqueName=" + this.uniqueName + ", ";
        outputString = String.valueOf(outputString) + " version=" + this.getVersion() + ", ";
        outputString = String.valueOf(outputString) + " location=" + this.location + ", ";
        outputString = String.valueOf(outputString) + " uninstaller=" + this.uninstaller + ", ";
        outputString = String.valueOf(outputString) + " requiredComponents=" + this.requiredComponents + ", ";
        outputString = String.valueOf(outputString) + " dependentComponents=" + this.dependentComponents + ", ";
        outputString = String.valueOf(outputString) + " backwardCompatible=" + this.backwardCompatible;
        outputString = String.valueOf(outputString) + "]";
        return outputString;
    }
}

