/*
 * Decompiled with CFR 0.152.
 */
package com.sun.prodreg.awt;

import com.sun.prodreg.awt.Separator;
import com.sun.prodreg.util.Localizer;
import java.awt.Button;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.InputStream;
import java.util.StringTokenizer;

public class AboutDialog
extends Dialog
implements ActionListener {
    private Button ok;

    public AboutDialog(Frame parent) {
        super(parent, Localizer.resolve("<L ProdRegResources.AboutTitle>"), true);
        this.createUI();
        this.pack();
    }

    public void actionPerformed(ActionEvent evt) {
        if (evt.getSource().equals(this.ok)) {
            this.dispose();
        }
    }

    private void createUI() {
        String version;
        String copyright;
        String buildDate;
        byte[] buf = new byte[256];
        InputStream is = null;
        int n = 0;
        try {
            is = this.getClass().getResourceAsStream("/builddate");
            n = is.read(buf);
            is.close();
            buildDate = new String(buf, 0, n);
        }
        catch (Exception exception) {
            buildDate = Localizer.resolve("<L ProdRegResources.Unknown>");
        }
        try {
            is = this.getClass().getResourceAsStream("/copyright");
            n = is.read(buf);
            is.close();
            copyright = new String(buf, 0, n);
        }
        catch (Exception exception) {
            copyright = Localizer.resolve("<L ProdRegResources.DefaultCopyright>");
        }
        try {
            is = this.getClass().getResourceAsStream("/Version");
            n = is.read(buf);
            is.close();
            version = new String(buf, 0, n);
        }
        catch (Exception exception) {
            version = "3.x";
        }
        Panel p = new Panel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridwidth = 0;
        Label l1 = new Label(Localizer.resolve("<L ProdRegResources.AboutTitleLabel> " + version));
        l1.setFont(new Font("Dialog", 0, 18));
        p.add((Component)l1, c);
        l1 = new Label("(prodreg)");
        l1.setFont(new Font("Dialog", 0, 14));
        p.add((Component)l1, c);
        l1 = new Label(buildDate);
        l1.setFont(new Font("Dialog", 0, 9));
        p.add((Component)l1, c);
        StringTokenizer copyrightT = new StringTokenizer(copyright, "\n");
        while (copyrightT.hasMoreTokens()) {
            String ne = copyrightT.nextToken();
            l1 = new Label(ne);
            p.add((Component)l1, c);
        }
        this.setLayout(new GridBagLayout());
        GridBagConstraints topC = new GridBagConstraints();
        topC.gridwidth = 0;
        topC.fill = 1;
        topC.weightx = 1.0;
        topC.weighty = 1.0;
        this.add((Component)p, topC);
        topC.fill = 2;
        topC.weightx = 0.0;
        topC.weighty = 0.0;
        topC.ipady = 2;
        this.add((Component)new Separator(1), topC);
        Panel bp = new Panel(new FlowLayout(1));
        this.ok = new Button(Localizer.resolve("<L ProdRegResources.OK>"));
        this.ok.addActionListener(this);
        bp.add(this.ok);
        topC.ipady = 0;
        this.add(bp);
    }
}

