/*
 * Decompiled with CFR 0.152.
 */
package com.sun.prodreg.awt;

import com.sun.prodreg.awt.ComponentSelectableViewComponent;
import com.sun.prodreg.awt.Node;
import com.sun.prodreg.awt.RegNode;
import com.sun.prodreg.event.ExpansionEvent;
import com.sun.prodreg.event.ExpansionListener;
import com.sun.prodreg.event.NoExpansionException;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import java.util.Vector;

public class KioskCanvas
extends ComponentSelectableViewComponent {
    static int fontSize = 12;
    static Image closeImage = null;
    static Image openImage = null;
    static Image damageImage = null;
    MediaTracker imageTrack = null;
    Image bufferImage = null;
    Graphics bufferGraphics = null;
    private Cursor currentCursor = this.getCursor();
    public static final Cursor HAND_CURSOR = Cursor.getPredefinedCursor(12);
    public static final Cursor DEFAULT_CURSOR = Cursor.getPredefinedCursor(0);
    int currentHeight = 0;
    int currentWidth = 0;
    Vector treeDisplay = new Vector();
    Vector raw = null;
    Vector eListeners = new Vector();
    private Image offscreen;
    private Dimension oldSize;

    public KioskCanvas(Vector raw, Image openImage, Image closeImage, Image damageImage) {
        KioskCanvas.damageImage = damageImage;
        this.raw = raw;
        try {
            this.addMouseListener(new MouseKit());
            this.imageTrack = new MediaTracker(this);
            KioskCanvas.closeImage = closeImage;
            if (openImage != null) {
                this.imageTrack.addImage(KioskCanvas.closeImage, 1);
            }
            if (closeImage != null) {
                this.imageTrack.addImage(KioskCanvas.openImage, 2);
            }
            if (damageImage != null) {
                this.imageTrack.addImage(KioskCanvas.damageImage, 3);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void _paint(Graphics g) {
        int ypos = 0;
        if (this.imageTrack != null) {
            try {
                this.imageTrack.waitForAll();
            }
            catch (InterruptedException interruptedException) {
                System.out.println("Problem waiting for images to load...");
            }
        }
        g.setColor(Node.fontColor);
        this.treeDisplay.removeAllElements();
        Enumeration e = this.raw.elements();
        while (e.hasMoreElements()) {
            Node n = (Node)e.nextElement();
            ypos = n.paintNode(g, this.isEnabled(), this.treeDisplay, 20, ypos + Node.nodeLeading);
        }
    }

    static /* synthetic */ Dimension access$0(KioskCanvas $0) {
        return $0.oldSize;
    }

    public void addExpansionListener(ExpansionListener l) {
        if (!this.eListeners.contains(l)) {
            this.eListeners.addElement(l);
        }
    }

    public void console(String comment) {
        System.out.println(comment);
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public Dimension getPreferredSize() {
        int width = 0;
        int height = 0;
        Font fnt = this.getFont();
        if (fnt != null) {
            FontMetrics fm = this.getFontMetrics(fnt);
            Enumeration e = this.raw.elements();
            while (e.hasMoreElements()) {
                Node n = (Node)e.nextElement();
                Dimension nSize = n.requiredSize(fm, Node.nodeIndent);
                height += nSize.height;
                if (nSize.width <= width) continue;
                width = nSize.width;
            }
            Dimension sz = new Dimension(width + 2, height + 2);
            return sz;
        }
        throw new InternalError("no Font for KioskCanvas");
    }

    public void leftAction(Node n) {
        try {
            ExpansionEvent eev = new ExpansionEvent(n.getTreeNode().getComponentDescription(), n.expand ^ true);
            int i = 0;
            while (i < this.eListeners.size()) {
                ExpansionListener lis = (ExpansionListener)this.eListeners.elementAt(i);
                lis.expanding(eev);
                ++i;
            }
            n.expand ^= true;
            int width = this.getSize().width;
            int height = this.getPreferredSize().height;
            this.setSize(new Dimension(width, height));
            this.validate();
            Component t = this;
            while ((t = t.getParent()) != null) {
                t.validate();
            }
            this.repaint();
            this.componentSelected(n.getTreeNode().getComponentDescription());
        }
        catch (NoExpansionException noExpansionException) {}
    }

    int mouseLine(int y) {
        return (y - Node.nodeLeading / 2) / Node.nodeLeading;
    }

    public void paint(Graphics g) {
        Dimension size = this.getSize();
        if (this.offscreen == null || size.width != this.currentWidth || size.height != this.currentHeight) {
            if (this.offscreen != null) {
                this.offscreen.flush();
            }
            this.offscreen = this.createImage(size.width, size.height);
            this.currentWidth = size.width;
            this.currentHeight = size.height;
        }
        if (!size.equals(this.oldSize)) {
            this.oldSize = size;
            Graphics bufferGraphics = this.offscreen.getGraphics();
            bufferGraphics.setColor(this.getBackground());
            bufferGraphics.fillRect(0, 0, size.width, size.height);
            bufferGraphics.setColor(this.getForeground());
            this._paint(bufferGraphics);
        }
        g.drawImage(this.offscreen, 0, 0, this);
    }

    public void refresh(Vector idsToExpand, boolean expand) {
        int i = 0;
        while (i < this.raw.size()) {
            Node n = (Node)this.raw.elementAt(i);
            n.refresh(idsToExpand, expand);
            ++i;
        }
    }

    public void removeExpansionListener(ExpansionListener l) {
        if (this.eListeners.contains(l)) {
            this.eListeners.removeElement(l);
        }
    }

    public void rightAction(Node n) {
        this.componentSelected(n.getTreeNode().getComponentDescription());
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        int width = this.getSize().width;
        int height = this.getPreferredSize().height;
        this.setSize(new Dimension(width, height));
        this.validate();
        Component t = this;
        while ((t = t.getParent()) != null) {
            t.validate();
        }
        this.repaint();
    }

    class MouseKit
    extends MouseAdapter {
        MouseKit() {
        }

        public void mouseClicked(MouseEvent e) {
            int xPos = e.getX();
            int yPos = e.getY();
            int line = KioskCanvas.this.mouseLine(yPos);
            if (line < 0) {
                return;
            }
            if (line > KioskCanvas.this.treeDisplay.size() - 1) {
                if (Node.nodeSelected != null) {
                    Node.nodeSelected = null;
                    KioskCanvas.this.oldSize = new Dimension(0, 0);
                    KioskCanvas.this.repaint();
                }
                return;
            }
            RegNode reg = (RegNode)KioskCanvas.this.treeDisplay.elementAt(line);
            if (!reg.node.getTreeNode().isSelectable()) {
                return;
            }
            Node.nodeSelected = reg.node;
            KioskCanvas.this.oldSize = new Dimension(0, 0);
            KioskCanvas.this.repaint();
            if (xPos < reg.x) {
                KioskCanvas.this.leftAction(reg.node);
            } else {
                KioskCanvas.this.rightAction(reg.node);
            }
        }
    }
}

