/*
 * Decompiled with CFR 0.152.
 */
package com.sun.prodreg.core;

import com.sun.prodreg.event.ProgressListener;

public class ProgressUpdater
extends Thread {
    private int min;
    private int max;
    private double time;
    private ProgressListener listener;
    boolean done = false;
    private Object doneLock = new Object();

    public ProgressUpdater(ProgressListener listener, int min, int max, double time) {
        super("ProgressUpdater from " + min + " to " + max + " in " + time + "s");
        this.min = min;
        this.listener = listener;
        this.max = max;
        this.time = time;
    }

    public void run() {
        long waitTime = (long)(this.time * 1000.0 / (double)(this.max - this.min));
        long doneTime = (long)this.time * 1000L;
        long sofar = 0L;
        while (!this.done) {
            int progress = this.min;
            this.listener.setProgress(progress += (int)((double)sofar / (double)doneTime * (double)(this.max - this.min)));
            try {
                Thread.sleep(waitTime);
                if ((sofar += waitTime) < doneTime) continue;
                Object object = this.doneLock;
                synchronized (object) {
                    this.done = true;
                }
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public void stopUpdating() {
        Object object = this.doneLock;
        synchronized (object) {
            this.done = true;
        }
    }
}

