/*
 * Decompiled with CFR 0.152.
 */
package com.sun.prodreg.core;

import com.sun.prodreg.core.ComponentDescription;
import com.sun.prodreg.core.InstallManager;
import com.sun.prodreg.core.Registry;
import com.sun.prodreg.core.RegistryNotAvailableException;
import com.sun.prodreg.core.RegistryQuery;
import com.sun.prodreg.core.UIProvider;
import com.sun.prodreg.event.ProgressListener;
import com.sun.prodreg.util.Localizer;
import com.sun.prodreg.util.TypedSystemSubprocess;
import com.sun.prodreg.view.ComponentSelectableView;
import com.sun.prodreg.view.ProgressView;
import com.sun.prodreg.view.ViewManager;
import java.util.Vector;

public class WebstartRegistry
implements Registry {
    public static final String REGCONVERT_UTIL = "/usr/sadm/install/bin/regconvert";
    private static final int WSREG_FILE_NOT_FOUND = 1;
    private static final int WSREG_NO_REG_ACCESS = 2;
    private static final int WSREG_NO_FILE_ACCESS = 3;
    private static final int WSREG_UNZIP_ERROR = 4;
    private static final int WSREG_CANT_CREATE_TMP_DIR = 5;
    private static final int WSREG_UNZIP_NOT_INSTALLED = 6;
    private static final int WSREG_BAD_REGISTRY_FILE = 7;
    private static final int WSREG_SUCCESS = 8;
    private static final int WSREG_O_RDONLY = 5;
    private static final int WSREG_O_RDWR = 6;
    private ViewManager vm = null;
    private InstallManager mgr = null;

    static {
        System.loadLibrary("prodreg");
    }

    public synchronized native void cleanup();

    private synchronized native int convert(String var1, ProgressListener var2);

    private void convertRegistry(String oldRegistry, ProgressListener listener) {
        int res = this.convert(oldRegistry, listener);
        Object[] arg = new String[]{oldRegistry};
        switch (res) {
            case 1: {
                String message = Localizer.resolve("<L ProdRegResources.NoConversionFileFound>", arg);
                this.noConversion(message, oldRegistry);
                break;
            }
            case 3: {
                String message = Localizer.resolve("<L ProdRegResources.NoConversionFileAccess>", arg);
                this.manualConversion(message, oldRegistry);
                break;
            }
            case 2: {
                String message = Localizer.resolve("<L ProdRegResources.NoConversionRegAccess>", arg);
                this.manualConversion(message, oldRegistry);
                break;
            }
            case 4: {
                String message = Localizer.resolve("<L ProdRegResources.NoConversionBadReg>", arg);
                this.noConversion(message, oldRegistry);
                break;
            }
            case 5: {
                String message = Localizer.resolve("<L ProdRegResources.NoConversionTmpDir>", arg);
                this.noConversion(message, oldRegistry);
                break;
            }
            case 6: {
                String message = Localizer.resolve("<L ProdRegResources.NoConversionNoUnzip>", arg);
                this.noConversion(message, oldRegistry);
                break;
            }
            case 7: {
                String message = Localizer.resolve("<L ProdRegResources.NoConversionBadReg>", arg);
                this.noConversion(message, oldRegistry);
                break;
            }
            case 8: {
                String message = Localizer.resolve("<L ProdRegResources.ConversionSuccess>", arg);
                String title = Localizer.resolve("<L ProdRegResources.NeedConversionTitle>");
                String ok = Localizer.resolve("<L ProdRegResources.OK>");
                this.vm.query(title, message, null, new String[]{ok});
                break;
            }
            default: {
                String message = Localizer.resolve("<L ProdRegResources.NoConversionUnknown>", arg);
                this.manualConversion(message, oldRegistry);
            }
        }
    }

    public Vector getAllComponents(int type, ProgressListener listener) throws RegistryNotAvailableException {
        switch (type) {
            case 1: {
                return this.getAllComponents(listener);
            }
            case 0: {
                return this.getSystemComponents(listener);
            }
        }
        throw new IllegalArgumentException("WebstartRegistry: getAllComponents: bad type:" + type);
    }

    public synchronized native Vector getAllComponents(ProgressListener var1) throws RegistryNotAvailableException;

    public synchronized native ComponentDescription getComponent(RegistryQuery var1) throws RegistryNotAvailableException;

    private synchronized native String getOldRegistryName();

    public synchronized native Vector getSystemComponents(ProgressListener var1) throws RegistryNotAvailableException;

    public void initialize(ViewManager vm, UIProvider provider, InstallManager mgr, String altRoot) {
        this.vm = vm;
        this.mgr = mgr;
        this.loadClasses();
        if (!this.initializeNoConversion(altRoot)) {
            String oldReg = this.getOldRegistryName();
            Object[] arg = new String[]{oldReg};
            String pr = Localizer.resolve("<L ProdRegResources.NeedConversion>", arg);
            String prinfo = Localizer.resolve("<L ProdRegResources.NeedConversionInfo>");
            String prtitle = Localizer.resolve("<L ProdRegResources.NeedConversionTitle>");
            String ok = Localizer.resolve("<L ProdRegResources.OK>");
            String cancel = Localizer.resolve("<L ProdRegResources.Cancel>");
            int res = vm.query(prtitle, pr, prinfo, new String[]{ok, cancel});
            if (res == 0) {
                String message = Localizer.resolve("<L ProdRegResources.ConversionWait>");
                ProgressView v = provider.getWaitView(message);
                ComponentSelectableView oldView = vm.getTreeView();
                vm.setTreeView(v);
                this.convertRegistry(oldReg, v);
                vm.setTreeView(oldView);
            } else {
                pr = Localizer.resolve("<L ProdRegResources.ConversionCancelled>");
                vm.query(prtitle, pr, null, new String[]{ok});
                return;
            }
        }
    }

    private synchronized native boolean initializeNoConversion(String var1);

    public synchronized native boolean isRegistryAvailable(int var1);

    private synchronized native void loadClasses();

    synchronized native ComponentDescription loopback(ComponentDescription var1);

    private void manualConversion(String message, String oldRegistry) {
        String title = Localizer.resolve("<L ProdRegResources.NeedConversionTitle>");
        String ok = Localizer.resolve("<L ProdRegResources.OK>");
        String quit = Localizer.resolve("<L ProdRegResources.Quit>");
        String cancel = Localizer.resolve("<L ProdRegResources.Cancel>");
        Object[] arg = new String[]{oldRegistry};
        int result = this.vm.query(title, message, null, new String[]{ok, cancel});
        if (result == 0) {
            if (!this.runConverter()) {
                message = Localizer.resolve("<L ProdRegResources.ManualConversionFailed>", arg);
                result = this.vm.query(title, message, null, new String[]{ok, quit});
                if (result == 1) {
                    this.mgr.close(1);
                }
            }
        } else {
            message = Localizer.resolve("<L ProdRegResources.ConversionCancelled>", arg);
            this.vm.query(title, message, null, new String[]{ok});
        }
    }

    private void noConversion(String message, String oldRegistry) {
        String title = Localizer.resolve("<L ProdRegResources.ConversionImpossibleTitle>");
        String ok = Localizer.resolve("<L ProdRegResources.OK>");
        String quit = Localizer.resolve("<L ProdRegResources.Quit>");
        String cancel = Localizer.resolve("<L ProdRegResources.Cancel>");
        String[] arg = new String[]{oldRegistry};
        int result = this.vm.query(title, message, null, new String[]{ok, quit});
        if (result == 1) {
            this.mgr.close(1);
        }
    }

    public native boolean registerComponent(ComponentDescription var1) throws RegistryNotAvailableException;

    private boolean runConverter() {
        String util = REGCONVERT_UTIL;
        String altRoot = System.getProperty("prodreg.pkgroot");
        if (altRoot != null) {
            util = String.valueOf(util) + " -R " + altRoot;
        }
        String cmd = "bin/rootrun " + TypedSystemSubprocess.escape(' ', util);
        String prompt = Localizer.resolve("<L ProdRegResources.EnterRootPassword>");
        cmd = String.valueOf(cmd) + " " + TypedSystemSubprocess.escape(' ', prompt);
        String home = System.getProperty("prodreg.home");
        TypedSystemSubprocess converter = new TypedSystemSubprocess(home, cmd, 2);
        converter.run();
        return converter.getResult() == 0;
    }

    public synchronized native void setAlternateRoot(String var1) throws RegistryNotAvailableException;

    public synchronized native boolean unregisterComponent(ComponentDescription var1) throws RegistryNotAvailableException;
}

