/*
 * Decompiled with CFR 0.152.
 */
package com.sun.prodreg.swing;

import com.sun.prodreg.core.ComponentDescription;
import com.sun.prodreg.core.ComponentDescriptionLookup;
import com.sun.prodreg.core.ComponentReference;
import com.sun.prodreg.core.ProdReg;
import com.sun.prodreg.core.ProdRegTreeNode;
import com.sun.prodreg.util.Utils;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;

class JTreeComponentDescriptionWrapper
implements MutableTreeNode {
    private TreeNode parent = null;
    private ProdRegTreeNode node = null;
    private Vector childCache = null;

    public JTreeComponentDescriptionWrapper(ProdRegTreeNode node, TreeNode parent) {
        this.node = node;
        this.parent = parent;
    }

    public Enumeration children() {
        this.verify();
        return this.childCache.elements();
    }

    public boolean getAllowsChildren() {
        this.verify();
        return this.childCache.size() > 0;
    }

    public TreeNode getChildAt(int childIndex) {
        this.verify();
        return (TreeNode)this.childCache.elementAt(childIndex);
    }

    public int getChildCount() {
        this.verify();
        return this.childCache.size();
    }

    public int getIndex(TreeNode node) {
        this.verify();
        return this.childCache.indexOf(node);
    }

    public TreeNode getParent() {
        return this.parent;
    }

    public ProdRegTreeNode getTreeNode() {
        return this.node;
    }

    public void insert(MutableTreeNode child, int index) {
    }

    public boolean isLeaf() {
        this.verify();
        return this.getAllowsChildren() ^ true;
    }

    public void refresh(Vector nodesToExpand, Vector idsToExpand) {
        int cnt = this.getChildCount();
        int i = 0;
        while (i < cnt) {
            this.remove(i);
            ++i;
        }
        this.childCache = null;
        this.verify();
        int sz = this.childCache.size();
        int i2 = 0;
        while (i2 < sz) {
            JTreeComponentDescriptionWrapper kid = (JTreeComponentDescriptionWrapper)this.childCache.elementAt(i2);
            kid.refresh(nodesToExpand, idsToExpand);
            ++i2;
        }
        String myID = this.node.getComponentDescription().getID();
        int i3 = 0;
        while (i3 < idsToExpand.size()) {
            if (myID != null && myID.equals(idsToExpand.elementAt(i3))) {
                nodesToExpand.addElement(this);
            }
            ++i3;
        }
    }

    public void remove(int index) {
    }

    public void remove(MutableTreeNode node) {
    }

    public void removeFromParent() {
    }

    public void setParent(MutableTreeNode newParent) {
    }

    public void setUserObject(Object object) {
    }

    public String toString() {
        return this.node.toString();
    }

    private void verify() {
        if (this.childCache == null) {
            ComponentReference[] kids;
            this.childCache = new Vector();
            Vector childDescCache = new Vector();
            if (this.node.getComponentDescription() != null && (kids = this.node.getComponentDescription().getChildren()) != null) {
                ComponentDescription childNode;
                int i = 0;
                while (i < kids.length) {
                    childNode = ComponentDescriptionLookup.get(kids[i].getID());
                    if (childNode != null) {
                        childDescCache.addElement(childNode);
                    } else if (ProdReg.debug) {
                        String id = this.node.getComponentDescription().getID();
                        System.out.println("warning: could not findchild of " + id + " with id " + kids[i].getID() + " could not be found");
                    }
                    ++i;
                }
                childDescCache = Utils.alphaCache(childDescCache);
                int sz = childDescCache.size();
                int i2 = 0;
                while (i2 < sz) {
                    childNode = (ComponentDescription)childDescCache.elementAt(i2);
                    ProdRegTreeNode newNode = new ProdRegTreeNode(childNode);
                    JTreeComponentDescriptionWrapper w = new JTreeComponentDescriptionWrapper(newNode, this);
                    this.childCache.addElement(w);
                    ++i2;
                }
            }
        }
    }
}

