/*
 * Decompiled with CFR 0.152.
 */
package com.sun.prodreg.swing;

import com.sun.prodreg.core.ProdRegTreeNode;
import com.sun.prodreg.core.ProgressBar;
import com.sun.prodreg.core.UIProvider;
import com.sun.prodreg.swing.SwingMoreView;
import com.sun.prodreg.swing.SwingProgressBar;
import com.sun.prodreg.swing.SwingTreeView;
import com.sun.prodreg.swing.SwingWaitView;
import com.sun.prodreg.view.ComponentView;
import com.sun.prodreg.view.ProgressView;
import com.sun.prodreg.view.SummaryView;
import com.sun.prodreg.view.TreeView;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class SwingUIProvider
implements UIProvider {
    Font smallFont;
    Font medFont;
    Font largeFont;

    public SwingUIProvider() {
        Font smallFont = new Font("Dialog", 0, 10);
        Font medFont = new Font("Dialog", 0, 12);
        Font largeFont = new Font("Dialog", 1, 14);
    }

    public Component getButton(String label, ActionListener listener) {
        JButton b = new JButton(label);
        b.addActionListener(listener);
        return b;
    }

    public Container getContainer(LayoutManager l) {
        return new JPanel(l);
    }

    public Frame getFrame(String title, Component toAdd) {
        JFrame f = new JFrame(title);
        f.getContentPane().add(toAdd);
        f.setDefaultCloseOperation(0);
        return f;
    }

    public Component getLabel(String l, int style) {
        JLabel label = new JLabel(l);
        switch (style) {
            case 0: {
                label.setFont(this.smallFont);
                break;
            }
            case 1: {
                label.setFont(this.medFont);
                break;
            }
            case 2: {
                label.setFont(this.largeFont);
                break;
            }
            case 3: {
                label.setFont(this.largeFont);
                label.setForeground(Color.red);
                break;
            }
            default: {
                throw new IllegalArgumentException("getLabel: invalid style:" + style);
            }
        }
        return label;
    }

    public ComponentView getMoreView() {
        SwingMoreView m = new SwingMoreView();
        return m;
    }

    public ProgressBar getProgressBar() {
        return new SwingProgressBar();
    }

    public ComponentView getSummaryView() {
        SummaryView s = new SummaryView();
        return s;
    }

    public TreeView getTreeView(ProdRegTreeNode data) {
        return new SwingTreeView(data);
    }

    public ProgressView getWaitView(String message) {
        SwingWaitView m = new SwingWaitView(message);
        return m;
    }
}

