/*
 * Decompiled with CFR 0.152.
 */
package com.sun.prodreg.util;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Hashtable;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class JarLoader
extends ClassLoader {
    private ZipFile zipFile;
    private Hashtable classCache;
    static /* synthetic */ Class array$Ljava$lang$String;

    public JarLoader(String jarPath, String mainClass, String[] args) throws IOException, ClassNotFoundException, InvocationTargetException, IllegalAccessException, NoSuchMethodException {
        this.zipFile = new ZipFile(jarPath);
        this.runJarProgram(mainClass, args);
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    private void cleanup() throws IOException {
        this.zipFile.close();
        this.zipFile = null;
        if (this.classCache != null) {
            this.classCache.clear();
            this.classCache = null;
        }
    }

    protected void finalize() throws IOException {
        this.cleanup();
    }

    protected Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
        try {
            return this.findSystemClass(name);
        }
        catch (ClassNotFoundException classNotFoundException) {
            Object c;
            if (this.classCache == null) {
                this.classCache = new Hashtable();
            }
            if ((c = this.classCache.get(name)) != null) {
                return (Class)c;
            }
            Class cls = null;
            cls = this.loadIn(name);
            if (resolve) {
                this.resolveClass(cls);
            }
            this.classCache.put(name, cls);
            return cls;
        }
    }

    private Class loadIn(String name) throws ClassNotFoundException {
        String classfilename = String.valueOf(name.replace('.', '/')) + ".class";
        ZipEntry entry = this.zipFile.getEntry(classfilename);
        if (entry == null) {
            throw new ClassNotFoundException("ClassNotFound in jar file " + this.zipFile + ": " + name);
        }
        int nbytes = (int)entry.getSize();
        if (nbytes < 0) {
            nbytes = 16384;
        }
        byte[] buf = new byte[nbytes + 1000];
        int offset = 0;
        try {
            int n;
            InputStream is = this.zipFile.getInputStream(entry);
            while ((n = is.read(buf, offset, buf.length - offset)) >= 0) {
                if ((offset += n) <= buf.length - 500) continue;
                nbytes = buf.length + nbytes;
                byte[] newbuf = new byte[nbytes];
                System.arraycopy(buf, 0, newbuf, 0, offset);
                buf = newbuf;
            }
            is.close();
        }
        catch (IOException e) {
            throw new ClassNotFoundException("Error reading class " + name + " from " + this.zipFile + " at offset " + offset + ":" + e.toString());
        }
        return this.defineClass(name, buf, 0, offset);
    }

    private void runJarProgram(String mainClass, String[] jargs) throws IOException, ClassNotFoundException, InvocationTargetException, IllegalAccessException, NoSuchMethodException {
        Class<?> uclass = this.loadClass(mainClass);
        Class[] arglisttype = new Class[]{array$Ljava$lang$String != null ? array$Ljava$lang$String : (array$Ljava$lang$String = JarLoader.class$("[Ljava.lang.String;"))};
        Method mainmethod = uclass.getDeclaredMethod("main", arglisttype);
        Object[] args = new Object[]{jargs};
        mainmethod.invoke(null, args);
        this.cleanup();
    }
}

