/*
 * Decompiled with CFR 0.152.
 */
package com.sun.prodreg.util;

import java.text.MessageFormat;
import java.util.Hashtable;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class Localizer {
    private static Hashtable resourcebundles = new Hashtable();
    private static String[] resourcePackages;

    public static synchronized void addResourcePackage(String pkg) {
        if (resourcePackages == null) {
            resourcePackages = new String[]{pkg};
        } else {
            String[] newPackages = new String[resourcePackages.length + 1];
            System.arraycopy(resourcePackages, 0, newPackages, 0, resourcePackages.length);
            newPackages[newPackages.length - 1] = pkg;
            resourcePackages = newPackages;
        }
    }

    private static synchronized ResourceBundle getResourceBundle(String resourceClassName) throws RuntimeException {
        String resourceName = null;
        if (resourceClassName.indexOf(".") > 0) {
            resourceName = resourceClassName;
            if (resourcebundles.containsKey(resourceName)) {
                return (ResourceBundle)resourcebundles.get(resourceName);
            }
            try {
                ResourceBundle res = ResourceBundle.getBundle(resourceName);
                resourcebundles.put(resourceName, res);
                return res;
            }
            catch (MissingResourceException missingResourceException) {}
        } else {
            if (resourcePackages == null) {
                throw new RuntimeException("No registered packages, cannot resolve " + resourceClassName);
            }
            int i = 0;
            while (i < resourcePackages.length) {
                resourceName = String.valueOf(resourcePackages[i]) + "." + resourceClassName;
                if (resourcebundles.containsKey(resourceName)) {
                    return (ResourceBundle)resourcebundles.get(resourceName);
                }
                ++i;
            }
            int i2 = 0;
            if (i2 < resourcePackages.length) {
                resourceName = String.valueOf(resourcePackages[i2]) + "." + resourceClassName;
                try {
                    ResourceBundle res = ResourceBundle.getBundle(resourceName);
                    resourcebundles.put(resourceName, res);
                    return res;
                }
                catch (MissingResourceException missingResourceException) {
                    throw new RuntimeException("Could not obtain localization bundled \"" + resourceName + "\"");
                }
            }
        }
        return null;
    }

    public static String localeName(Locale locale) {
        String name = new String();
        if (locale != null) {
            String variant;
            String language;
            name = language = locale.getLanguage();
            String country = locale.getCountry();
            if (country.length() > 0) {
                name = String.valueOf(language) + "_" + country;
            }
            if ((variant = locale.getVariant()).length() > 0) {
                name = String.valueOf(name) + "." + variant;
            }
        }
        return name;
    }

    private static String localize(String reference) throws RuntimeException {
        if (reference == null) {
            throw new RuntimeException("localize: Invalid reference: " + reference);
        }
        String resourceClassName = null;
        String resourceKey = null;
        int idx = reference.lastIndexOf(46);
        if (idx <= 0) {
            return reference;
        }
        resourceClassName = reference.substring(0, idx);
        resourceKey = reference.substring(idx + 1, reference.length());
        ResourceBundle res = Localizer.getResourceBundle(resourceClassName);
        String msg = null;
        if (res != null) {
            try {
                msg = res.getString(resourceKey);
            }
            catch (MissingResourceException e) {
                throw new RuntimeException("localized string " + resourceClassName + "." + resourceKey + " not found:" + e.toString());
            }
        } else {
            throw new RuntimeException("resource bundle " + resourceClassName + " not found");
        }
        return msg;
    }

    public static String resolve(String s) throws RuntimeException {
        if (s == null) {
            return null;
        }
        int slength = s.length();
        StringBuffer ret = new StringBuffer();
        int i = 0;
        while (i < slength) {
            char c = s.charAt(i);
            if (c == '<') {
                int closePos = s.indexOf(62, i + 1);
                if (closePos == -1) {
                    ret.append(s.substring(i));
                    break;
                }
                ret.append(Localizer.resolveTag(s.substring(i + 1, closePos)));
                i = closePos;
            } else {
                ret.append(c);
            }
            ++i;
        }
        return ret.toString();
    }

    public static String resolve(String s, Object[] args) throws RuntimeException {
        String pre_resolve = Localizer.resolve(s);
        MessageFormat msgFmt = new MessageFormat(pre_resolve);
        String rtn = null;
        try {
            rtn = msgFmt.format(args);
        }
        catch (NullPointerException nullPointerException) {
            rtn = pre_resolve;
        }
        if (rtn == null) {
            rtn = "***" + s + " --> UNABLE TO RESOLVE ***";
        }
        return rtn;
    }

    private static String resolveTag(String tag) throws RuntimeException {
        int len = tag.length();
        int i = 0;
        while (i < len && Character.isWhitespace(tag.charAt(i))) {
            ++i;
        }
        int tagNameStart = i;
        while (i < len && !Character.isWhitespace(tag.charAt(i))) {
            ++i;
        }
        String tagName = tag.substring(tagNameStart, i);
        while (i < len && Character.isWhitespace(tag.charAt(i))) {
            ++i;
        }
        int tagValueStart = i;
        while (i < len && !Character.isWhitespace(tag.charAt(i))) {
            ++i;
        }
        String tagValue = tag.substring(tagValueStart, i);
        if (tagValue.length() > 0) {
            return Localizer.resolveTag(tagName, tagValue);
        }
        return Localizer.resolveTag("L", tagName);
    }

    private static String resolveTag(String tagName, String tagValue) throws RuntimeException {
        if (tagName.equalsIgnoreCase("L")) {
            return Localizer.localize(tagValue);
        }
        throw new RuntimeException("{UNKNOWN TAG TYPE: " + tagName + "' used in <" + tagName + " " + tagValue + ">}");
    }
}

