/*
 * Decompiled with CFR 0.152.
 */
package com.sun.prodreg.view;

import com.sun.prodreg.core.ComponentDescription;
import com.sun.prodreg.core.ProdregException;
import com.sun.prodreg.util.Localizer;
import com.sun.prodreg.util.Utils;
import com.sun.prodreg.view.ComponentView;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.Panel;

public class SummaryView
extends Panel
implements ComponentView {
    private ComponentDescription desc;
    private Label name;
    private Label version;
    private Label location;
    private Label size;
    private Label installedOn;
    private Label installedFrom;
    private Label vendor;

    public SummaryView() {
        this.createUI();
    }

    private void createUI() throws ProdregException {
        Font smallFont = new Font("Dialog", 0, 10);
        Font mediumFont = new Font("Dialog", 0, 12);
        Font largeFont = new Font("Dialog", 1, 14);
        this.setLayout(new GridBagLayout());
        GridBagConstraints left = new GridBagConstraints();
        left.fill = 0;
        left.anchor = 13;
        GridBagConstraints right = new GridBagConstraints();
        right.fill = 1;
        right.anchor = 17;
        right.gridwidth = 0;
        right.weightx = 1.0;
        Label nameLabel = new Label(Localizer.resolve("<L ProdRegResources.Title>: "));
        Label versionLabel = new Label(Localizer.resolve("<L ProdRegResources.Version>: "));
        Label locationLabel = new Label(Localizer.resolve("<L ProdRegResources.Location>: "));
        Label sizeLabel = new Label(Localizer.resolve("<L ProdRegResources.CurrentSize>: "));
        Label installedOnLabel = new Label(Localizer.resolve("<L ProdRegResources.InstalledOn>: "));
        Label installedFromLabel = new Label(Localizer.resolve("<L ProdRegResources.InstalledFrom>: "));
        Label vendorLabel = new Label(Localizer.resolve("<L ProdRegResources.Vendor>: "));
        nameLabel.setFont(smallFont);
        versionLabel.setFont(smallFont);
        locationLabel.setFont(smallFont);
        sizeLabel.setFont(smallFont);
        installedOnLabel.setFont(smallFont);
        installedFromLabel.setFont(smallFont);
        vendorLabel.setFont(smallFont);
        this.name = new Label("");
        this.version = new Label("");
        this.location = new Label("");
        this.size = new Label("");
        this.installedOn = new Label("");
        this.installedFrom = new Label("");
        this.vendor = new Label("");
        this.fillLabels(this.desc);
        this.name.setFont(mediumFont);
        this.version.setFont(mediumFont);
        this.location.setFont(mediumFont);
        this.size.setFont(mediumFont);
        this.installedOn.setFont(mediumFont);
        this.installedFrom.setFont(mediumFont);
        this.vendor.setFont(mediumFont);
        this.add((Component)nameLabel, left);
        this.add((Component)this.name, right);
        this.add((Component)versionLabel, left);
        this.add((Component)this.version, right);
        this.add((Component)locationLabel, left);
        this.add((Component)this.location, right);
        this.add((Component)sizeLabel, left);
        this.add((Component)this.size, right);
        this.add((Component)installedOnLabel, left);
        this.add((Component)this.installedOn, right);
        this.add((Component)installedFromLabel, left);
        this.add((Component)this.installedFrom, right);
        this.add((Component)vendorLabel, left);
        this.add((Component)this.vendor, right);
    }

    private void fillLabels(ComponentDescription desc) {
        String nameString = "";
        String versionString = "";
        String locationString = "";
        String sizeString = "";
        String installedOnString = "";
        String installedFromString = "";
        String vendorString = "";
        if (desc != null) {
            nameString = Utils.getDisplayName(desc);
            if (nameString == null) {
                nameString = "";
            }
            if ((versionString = desc.getVersion()) == null) {
                versionString = "";
            }
            if ((locationString = desc.getLocation()) == null) {
                locationString = "";
            }
            if ((sizeString = desc.getData("installdiskspace")) == null) {
                sizeString = "";
            }
            if ((installedOnString = "") == null) {
                installedOnString = "";
            }
            if ((installedFromString = desc.getData("source")) == null) {
                installedFromString = "";
            }
            if ((vendorString = desc.getVendor()) == null) {
                vendorString = "";
            }
        } else {
            nameString = "";
            versionString = "";
            locationString = "";
            sizeString = "";
            installedOnString = "";
            installedFromString = "";
            vendorString = "";
        }
        this.name.setText(nameString);
        this.version.setText(versionString);
        this.location.setText(locationString);
        this.size.setText(sizeString);
        this.installedOn.setText(installedOnString);
        this.installedFrom.setText(installedFromString);
        this.vendor.setText(vendorString);
    }

    public ComponentDescription getDescription() {
        return this.desc;
    }

    public void setDescription(ComponentDescription desc) {
        this.desc = desc;
        this.fillLabels(desc);
    }

    public void showComponent(ComponentDescription desc) {
        this.setDescription(desc);
        this.validate();
        this.invalidate();
    }
}

