/*
 * Decompiled with CFR 0.152.
 */
package com.sun.forte.licen;

import com.sun.forte.licen.SNValidation;
import com.sun.forte.licen.SerialConstants;
import com.sun.forte.licen.SerialNumber;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Random;
import java.util.ResourceBundle;
import java.util.Vector;

public class SerNumUtils
implements SerialConstants {
    static ResourceBundle snRes = ResourceBundle.getBundle("com.sun.forte.licen.SerInstallResource");
    private static final int EOS_MARKER = -252645136;
    private static final int IMASK = 4095;
    private static final String CLEAR_STAT = "";
    private static final String UNIX_FILE_SEP = "/";
    private static final String UNIX_CHMOD_CMD = "/bin/chmod 644 ";
    private static Vector serialNoVec = null;
    private static String serialLicFile = null;
    private static String serUtilStatus = null;

    private SerNumUtils() {
    }

    public static int installSer(String string, String string2) {
        Vector vector = new Vector();
        boolean bl = SerNumUtils.isTrial(string);
        File file = new File(string2);
        if (SerNumUtils.checkLicFile(file) != 0) {
            return -1;
        }
        if (SerNumUtils.licFileExists(file)) {
            try {
                vector = SerNumUtils.getAllLics(string2);
            }
            catch (IOException iOException) {
                serUtilStatus = snRes.getString("Error_Unable_to_read") + string2;
                return -1;
            }
        }
        if (SerNumUtils.sameSerAlreadyInstalled(string, vector)) {
            serUtilStatus = snRes.getString("Error_already_installed");
            return -1;
        }
        if (bl && !vector.isEmpty() && SerNumUtils.prodAlreadyInstalled(string, vector)) {
            return -1;
        }
        SerNumUtils.updateSerialVector(string, vector);
        return SerNumUtils.realInstallSer(vector, file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Vector getAllLics(String string) throws IOException {
        if (serialNoVec != null && serialLicFile != null) {
            if (string.equals(serialLicFile)) {
                return serialNoVec;
            }
            serialLicFile = null;
            serialNoVec = null;
        }
        Vector<String> vector = new Vector<String>();
        serUtilStatus = CLEAR_STAT;
        FileInputStream fileInputStream = new FileInputStream(string);
        DataInputStream dataInputStream = new DataInputStream(fileInputStream);
        char[] cArray = new char[26];
        try {
            try {
                while (true) {
                    int n = 0;
                    while (n < 26) {
                        cArray[n] = (char)((dataInputStream.readInt() & 0xFFF) >> 4);
                        ++n;
                    }
                    if (-252645136 == dataInputStream.readInt()) {
                        vector.addElement(new String(cArray));
                        continue;
                    }
                    while (dataInputStream.readInt() != -252645136) {
                    }
                }
            }
            catch (EOFException eOFException) {
                Object var7_7 = null;
                fileInputStream.close();
            }
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            fileInputStream.close();
            throw throwable;
        }
        fileInputStream.close();
        if (!vector.isEmpty()) {
            serialNoVec = vector;
            serialLicFile = string;
        }
        return vector;
    }

    public static String getStatusMsg() {
        return serUtilStatus;
    }

    public static boolean isTrial(String string) {
        return SNValidation.isTrialSer(string);
    }

    public static boolean isTrial(SerialNumber serialNumber) {
        return SNValidation.isTrialSer(serialNumber.getSerialNo());
    }

    public static boolean snHasExpired(String string) {
        if (SerNumUtils.isTrial(string)) {
            return SNValidation.isExpired(string);
        }
        return false;
    }

    public static boolean snHasExpired(SerialNumber serialNumber) {
        return SerNumUtils.snHasExpired(serialNumber.getSerialNo());
    }

    public static SerialNumber checkForSerNum(String string, String string2) {
        Vector vector = new Vector();
        try {
            vector = SerNumUtils.getAllLics(string2);
        }
        catch (Exception exception) {
            return null;
        }
        if (vector.isEmpty()) {
            return null;
        }
        String string3 = string.substring(0, 3);
        String string4 = null;
        int n = 0;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            String string5 = (String)enumeration.nextElement();
            if (!string3.equals(string5.substring(0, 3)) || !(string4 = SNValidation.isProdSpec(string) || SerNumUtils.isProdSpecial(string5) ? string.substring(3, 6) : string.substring(3, 5)).equals(string5.substring(3, 3 + (n = string4.length())))) continue;
            return new SerialNumber(string5);
        }
        return null;
    }

    private static boolean isProdSpecial(String string) {
        SerialNumber serialNumber = new SerialNumber(string);
        if (serialNumber.isValid()) {
            return SNValidation.isProdSpec(string);
        }
        return false;
    }

    private static int realInstallSer(Vector vector, File file) {
        FileOutputStream fileOutputStream = null;
        DataOutputStream dataOutputStream = null;
        int n = -1;
        serUtilStatus = CLEAR_STAT;
        Random random = new Random();
        try {
            fileOutputStream = new FileOutputStream(file);
            dataOutputStream = new DataOutputStream(fileOutputStream);
        }
        catch (IOException iOException) {
            serUtilStatus = snRes.getString("Error_Unable_to_open");
            return -1;
        }
        int[] nArray = new int[26];
        Enumeration enumeration = vector.elements();
        try {
            String string;
            while (enumeration.hasMoreElements()) {
                string = (String)enumeration.nextElement();
                int n2 = 0;
                while (n2 < string.length()) {
                    nArray[n2] = string.charAt(n2) << 4;
                    int n3 = (int)(random.nextFloat() * 100000.0f);
                    nArray[n2] = nArray[n2] | (n3 <<= 12);
                    dataOutputStream.writeInt(nArray[n2]);
                    ++n2;
                }
                dataOutputStream.writeInt(-252645136);
            }
            fileOutputStream.close();
            string = System.getProperty("file.separator");
            if (string.equals(UNIX_FILE_SEP)) {
                Runtime.getRuntime().exec(UNIX_CHMOD_CMD + file.toString());
            }
            n = 0;
            serUtilStatus = snRes.getString("Serial_number_has");
        }
        catch (IOException iOException) {
            serUtilStatus = snRes.getString("Error_Error_occurred");
            return -1;
        }
        return n;
    }

    private static boolean licFileExists(File file) {
        return !file.isDirectory() && file.exists();
    }

    private static int checkLicFile(File file) {
        if (file.isDirectory()) {
            serUtilStatus = snRes.getString("Error_File_name") + file.toString();
            return -1;
        }
        if (file.exists()) {
            if (!file.canWrite()) {
                serUtilStatus = snRes.getString("Error_Unable_to_write") + file.toString();
                return -1;
            }
        } else {
            boolean bl;
            File file2;
            String string = file.getParent();
            if (string == null) {
                string = System.getProperty("user.dir");
            }
            if (!(file2 = new File(string)).exists() && !(bl = file2.mkdirs())) {
                serUtilStatus = snRes.getString("Error_Unable_to") + file2.toString();
                return -1;
            }
            if (!file2.canWrite()) {
                serUtilStatus = snRes.getString("Error_Unable_to_write1") + file2.toString();
                return -1;
            }
        }
        return 0;
    }

    private static boolean prodAlreadyInstalled(String string, Vector vector) {
        if (vector.isEmpty()) {
            return false;
        }
        String string2 = string.substring(0, 3);
        String string3 = null;
        int n = 0;
        string3 = SerNumUtils.isProdSpecial(string) ? string.substring(3, 6) : string.substring(3, 5);
        n = string3.length();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            String string4 = (String)enumeration.nextElement();
            if (!string2.equals(string4.substring(0, 3)) || !string3.equals(string4.substring(3, 3 + n))) continue;
            serUtilStatus = snRes.getString("Error_Trial_error");
            return true;
        }
        return false;
    }

    private static void updateSerialVector(String string, Vector vector) {
        if (vector.isEmpty()) {
            vector.addElement(string);
            return;
        }
        String string2 = string.substring(0, 3);
        String string3 = null;
        int n = 0;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            String string4 = (String)enumeration.nextElement();
            if (!SerNumUtils.isTrial(string4) || !string2.equals(string4.substring(0, 3)) || !(string3 = SerNumUtils.isProdSpecial(string) || SerNumUtils.isProdSpecial(string4) ? string.substring(3, 6) : string.substring(3, 5)).equals(string4.substring(3, 3 + (n = string3.length())))) continue;
            vector.removeElement(string4);
            vector.addElement(string);
            return;
        }
        vector.addElement(string);
    }

    private static boolean sameSerAlreadyInstalled(String string, Vector vector) {
        if (!vector.isEmpty()) {
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                String string2 = (String)enumeration.nextElement();
                if (!string.equals(string2)) continue;
                return true;
            }
        }
        return false;
    }

    private static String readNextSN(DataInputStream dataInputStream) throws IOException {
        serUtilStatus = CLEAR_STAT;
        char[] cArray = new char[26];
        try {
            while (true) {
                int n = 0;
                while (n < 26) {
                    cArray[n] = (char)((dataInputStream.readInt() & 0xFFF) >> 4);
                    ++n;
                }
                if (-252645136 == dataInputStream.readInt()) {
                    return new String(cArray);
                }
                while (dataInputStream.readInt() != -252645136) {
                }
            }
        }
        catch (EOFException eOFException) {
            return null;
        }
    }
}

