/*
 * Decompiled with CFR 0.152.
 */
package org.custommonkey.xmlunit;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import org.custommonkey.xmlunit.DoctypeSupport;

public class DoctypeReader
extends Reader {
    private final Reader originalReader;
    private final StringBuffer sourceBuffer = new StringBuffer(1024);
    private final DoctypeSupport support;

    public DoctypeReader(Reader originalSource, String doctypeName, String systemID) {
        this.originalReader = originalSource instanceof BufferedReader ? originalSource : new BufferedReader(originalSource);
        this.support = new DoctypeSupport(doctypeName, systemID, new DoctypeSupport.Readable(){

            public int read() throws IOException {
                return DoctypeReader.this.originalReader.read();
            }
        }, true, null);
    }

    protected String getContent() throws IOException {
        return this.getContent(this.originalReader).toString();
    }

    private StringBuffer getContent(Reader originalSource) throws IOException {
        if (this.sourceBuffer.length() == 0) {
            String source;
            BufferedReader bufferedReader = originalSource instanceof BufferedReader ? (BufferedReader)originalSource : new BufferedReader(originalSource);
            String newline = System.getProperty("line.separator");
            boolean atFirstLine = true;
            while ((source = bufferedReader.readLine()) != null) {
                if (atFirstLine) {
                    atFirstLine = false;
                } else {
                    this.sourceBuffer.append(newline);
                }
                this.sourceBuffer.append(source);
            }
            bufferedReader.close();
        }
        return this.sourceBuffer;
    }

    private int obsoleteFindStartDoctype(StringBuffer withinContent) {
        int startAt = -1;
        boolean canInsert = true;
        int i = 0;
        while (startAt == -1) {
            char curChar = withinContent.charAt(i);
            if (curChar == '<') {
                switch (withinContent.charAt(i + 1)) {
                    case '!': 
                    case '-': 
                    case '?': {
                        canInsert = false;
                        break;
                    }
                    default: {
                        startAt = i;
                        break;
                    }
                }
            } else if (curChar == '>') {
                canInsert = true;
            } else if (canInsert) {
                startAt = i;
            }
            ++i;
        }
        return startAt;
    }

    public String replaceDoctype(StringBuffer withinContent, String doctypeName, String systemId) {
        String content = withinContent.toString();
        int startDoctype = content.indexOf("DOCTYPE ");
        boolean noCurrentDoctype = false;
        if (startDoctype == -1) {
            startDoctype = this.obsoleteFindStartDoctype(withinContent);
            noCurrentDoctype = true;
        }
        int endDoctype = startDoctype + "DOCTYPE ".length();
        if (noCurrentDoctype) {
            withinContent.insert(startDoctype, "<!");
            withinContent.insert(startDoctype + "<!".length(), "DOCTYPE ");
            endDoctype += "<!".length();
        } else {
            int startInternalDecl = content.indexOf(91, endDoctype);
            if (startInternalDecl > 0) {
                int endInternalDecl = content.indexOf(93, startInternalDecl);
                withinContent.delete(endDoctype, endInternalDecl + 1);
            } else {
                int endDoctypeTag = content.indexOf(62, endDoctype);
                withinContent.delete(endDoctype, endDoctypeTag);
            }
        }
        int atPos = endDoctype;
        withinContent.insert(atPos, doctypeName);
        withinContent.insert(atPos += doctypeName.length(), " SYSTEM \"");
        withinContent.insert(atPos += " SYSTEM \"".length(), systemId);
        withinContent.insert(atPos += systemId.length(), '\"');
        if (noCurrentDoctype) {
            withinContent.insert(++atPos, ">");
        }
        return withinContent.toString();
    }

    public int read(char[] cbuf, int off, int len) throws IOException {
        int currentlyRead;
        int startPos = off;
        while (off - startPos < len && (currentlyRead = this.read()) != -1) {
            cbuf[off++] = (char)currentlyRead;
        }
        return off == startPos && len != 0 ? -1 : off - startPos;
    }

    public int read() throws IOException {
        return this.support.read();
    }

    public void close() throws IOException {
        this.originalReader.close();
    }
}

