/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.doxia.document;

import java.io.Serializable;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;
import org.apache.maven.doxia.document.DocumentAuthor;
import org.apache.maven.doxia.document.DocumentHyperlinkBehaviour;
import org.apache.maven.doxia.document.DocumentStatistic;
import org.apache.maven.doxia.document.DocumentTemplate;

public class DocumentMeta
implements Serializable {
    private String title;
    private String author;
    private List<DocumentAuthor> authors;
    private String subject;
    private String keywords;
    private List<String> keyWords;
    private String pageSize;
    private String generator;
    private String description;
    private String initialCreator;
    private String creator;
    private String printedBy;
    private Date creationDate;
    private String creationdate;
    private Date date;
    private String modifydate;
    private Date printDate;
    private String printdate;
    private DocumentTemplate template;
    private DocumentHyperlinkBehaviour hyperlinkBehaviour;
    private String language = "en-US";
    private long editingCycles = 0L;
    private long editingDuration = 0L;
    private DocumentStatistic documentStatistic;
    private boolean confidential = false;
    private boolean draft = false;
    private static final DateFormat ISO_8601_FORMAT = new SimpleDateFormat("yyyy-MM-dd", Locale.ENGLISH);

    public void addAuthor(DocumentAuthor documentAuthor) {
        this.getAuthors().add(documentAuthor);
    }

    public void addKeyWord(String string) {
        this.getKeyWords().add(string);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof DocumentMeta)) {
            return false;
        }
        DocumentMeta that = (DocumentMeta)other;
        boolean result = true;
        boolean bl = result && (this.getTitle() == null ? that.getTitle() == null : this.getTitle().equals(that.getTitle())) ? true : (result = false);
        boolean bl2 = result && (this.getAuthor() == null ? that.getAuthor() == null : this.getAuthor().equals(that.getAuthor())) ? true : (result = false);
        boolean bl3 = result && (this.getAuthors() == null ? that.getAuthors() == null : this.getAuthors().equals(that.getAuthors())) ? true : (result = false);
        boolean bl4 = result && (this.getSubject() == null ? that.getSubject() == null : this.getSubject().equals(that.getSubject())) ? true : (result = false);
        boolean bl5 = result && (this.getKeywords() == null ? that.getKeywords() == null : this.getKeywords().equals(that.getKeywords())) ? true : (result = false);
        boolean bl6 = result && (this.getKeyWords() == null ? that.getKeyWords() == null : this.getKeyWords().equals(that.getKeyWords())) ? true : (result = false);
        boolean bl7 = result && (this.getPageSize() == null ? that.getPageSize() == null : this.getPageSize().equals(that.getPageSize())) ? true : (result = false);
        boolean bl8 = result && (this.getGenerator() == null ? that.getGenerator() == null : this.getGenerator().equals(that.getGenerator())) ? true : (result = false);
        boolean bl9 = result && (this.getDescription() == null ? that.getDescription() == null : this.getDescription().equals(that.getDescription())) ? true : (result = false);
        boolean bl10 = result && (this.getInitialCreator() == null ? that.getInitialCreator() == null : this.getInitialCreator().equals(that.getInitialCreator())) ? true : (result = false);
        boolean bl11 = result && (this.getCreator() == null ? that.getCreator() == null : this.getCreator().equals(that.getCreator())) ? true : (result = false);
        boolean bl12 = result && (this.getPrintedBy() == null ? that.getPrintedBy() == null : this.getPrintedBy().equals(that.getPrintedBy())) ? true : (result = false);
        boolean bl13 = result && (this.getCreationDate() == null ? that.getCreationDate() == null : this.getCreationDate().equals(that.getCreationDate())) ? true : (result = false);
        boolean bl14 = result && (this.getCreationdate() == null ? that.getCreationdate() == null : this.getCreationdate().equals(that.getCreationdate())) ? true : (result = false);
        boolean bl15 = result && (this.getDate() == null ? that.getDate() == null : this.getDate().equals(that.getDate())) ? true : (result = false);
        boolean bl16 = result && (this.getModifydate() == null ? that.getModifydate() == null : this.getModifydate().equals(that.getModifydate())) ? true : (result = false);
        boolean bl17 = result && (this.getPrintDate() == null ? that.getPrintDate() == null : this.getPrintDate().equals(that.getPrintDate())) ? true : (result = false);
        boolean bl18 = result && (this.getPrintdate() == null ? that.getPrintdate() == null : this.getPrintdate().equals(that.getPrintdate())) ? true : (result = false);
        boolean bl19 = result && (this.getTemplate() == null ? that.getTemplate() == null : this.getTemplate().equals(that.getTemplate())) ? true : (result = false);
        boolean bl20 = result && (this.getHyperlinkBehaviour() == null ? that.getHyperlinkBehaviour() == null : this.getHyperlinkBehaviour().equals(that.getHyperlinkBehaviour())) ? true : (result = false);
        result = result && (this.getLanguage() == null ? that.getLanguage() == null : this.getLanguage().equals(that.getLanguage()));
        result = result && this.editingCycles == that.editingCycles;
        boolean bl21 = result = result && this.editingDuration == that.editingDuration;
        result = result && (this.getDocumentStatistic() == null ? that.getDocumentStatistic() == null : this.getDocumentStatistic().equals(that.getDocumentStatistic()));
        result = result && this.confidential == that.confidential;
        result = result && this.draft == that.draft;
        return result;
    }

    public String getAuthor() {
        return this.author;
    }

    public List<DocumentAuthor> getAuthors() {
        if (this.authors == null) {
            this.authors = new ArrayList<DocumentAuthor>();
        }
        return this.authors;
    }

    public Date getCreationDate() {
        return this.creationDate;
    }

    public String getCreator() {
        return this.creator;
    }

    public Date getDate() {
        return this.date;
    }

    public String getDescription() {
        return this.description;
    }

    public DocumentStatistic getDocumentStatistic() {
        return this.documentStatistic;
    }

    public long getEditingCycles() {
        return this.editingCycles;
    }

    public long getEditingDuration() {
        return this.editingDuration;
    }

    public String getGenerator() {
        return this.generator;
    }

    public DocumentHyperlinkBehaviour getHyperlinkBehaviour() {
        return this.hyperlinkBehaviour;
    }

    public String getInitialCreator() {
        return this.initialCreator;
    }

    public List<String> getKeyWords() {
        if (this.keyWords == null) {
            this.keyWords = new ArrayList<String>();
        }
        return this.keyWords;
    }

    public String getKeywords() {
        return this.keywords;
    }

    public String getLanguage() {
        return this.language;
    }

    public String getPageSize() {
        return this.pageSize;
    }

    public Date getPrintDate() {
        return this.printDate;
    }

    public String getPrintedBy() {
        return this.printedBy;
    }

    public String getSubject() {
        return this.subject;
    }

    public DocumentTemplate getTemplate() {
        return this.template;
    }

    public String getTitle() {
        return this.title;
    }

    public int hashCode() {
        int result = 17;
        result = 37 * result + (this.title != null ? this.title.hashCode() : 0);
        result = 37 * result + (this.author != null ? this.author.hashCode() : 0);
        result = 37 * result + (this.authors != null ? this.authors.hashCode() : 0);
        result = 37 * result + (this.subject != null ? this.subject.hashCode() : 0);
        result = 37 * result + (this.keywords != null ? this.keywords.hashCode() : 0);
        result = 37 * result + (this.keyWords != null ? this.keyWords.hashCode() : 0);
        result = 37 * result + (this.pageSize != null ? this.pageSize.hashCode() : 0);
        result = 37 * result + (this.generator != null ? this.generator.hashCode() : 0);
        result = 37 * result + (this.description != null ? this.description.hashCode() : 0);
        result = 37 * result + (this.initialCreator != null ? this.initialCreator.hashCode() : 0);
        result = 37 * result + (this.creator != null ? this.creator.hashCode() : 0);
        result = 37 * result + (this.printedBy != null ? this.printedBy.hashCode() : 0);
        result = 37 * result + (this.creationDate != null ? this.creationDate.hashCode() : 0);
        result = 37 * result + (this.creationdate != null ? this.creationdate.hashCode() : 0);
        result = 37 * result + (this.date != null ? this.date.hashCode() : 0);
        result = 37 * result + (this.modifydate != null ? this.modifydate.hashCode() : 0);
        result = 37 * result + (this.printDate != null ? this.printDate.hashCode() : 0);
        result = 37 * result + (this.printdate != null ? this.printdate.hashCode() : 0);
        result = 37 * result + (this.template != null ? this.template.hashCode() : 0);
        result = 37 * result + (this.hyperlinkBehaviour != null ? this.hyperlinkBehaviour.hashCode() : 0);
        result = 37 * result + (this.language != null ? this.language.hashCode() : 0);
        result = 37 * result + (int)(this.editingCycles ^ this.editingCycles >>> 32);
        result = 37 * result + (int)(this.editingDuration ^ this.editingDuration >>> 32);
        result = 37 * result + (this.documentStatistic != null ? this.documentStatistic.hashCode() : 0);
        result = 37 * result + (this.confidential ? 0 : 1);
        result = 37 * result + (this.draft ? 0 : 1);
        return result;
    }

    public boolean isConfidential() {
        return this.confidential;
    }

    public boolean isDraft() {
        return this.draft;
    }

    public void removeAuthor(DocumentAuthor documentAuthor) {
        this.getAuthors().remove(documentAuthor);
    }

    public void removeKeyWord(String string) {
        this.getKeyWords().remove(string);
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    public void setAuthors(List<DocumentAuthor> authors) {
        this.authors = authors;
    }

    public void setConfidential(boolean confidential) {
        this.confidential = confidential;
    }

    public void setCreationDate(Date creationDate) {
        this.creationDate = creationDate;
    }

    public void setCreationdate(String creationdate) {
        this.creationdate = creationdate;
    }

    public void setCreator(String creator) {
        this.creator = creator;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setDocumentStatistic(DocumentStatistic documentStatistic) {
        this.documentStatistic = documentStatistic;
    }

    public void setDraft(boolean draft) {
        this.draft = draft;
    }

    public void setEditingCycles(long editingCycles) {
        this.editingCycles = editingCycles;
    }

    public void setEditingDuration(long editingDuration) {
        this.editingDuration = editingDuration;
    }

    public void setGenerator(String generator) {
        this.generator = generator;
    }

    public void setHyperlinkBehaviour(DocumentHyperlinkBehaviour hyperlinkBehaviour) {
        this.hyperlinkBehaviour = hyperlinkBehaviour;
    }

    public void setInitialCreator(String initialCreator) {
        this.initialCreator = initialCreator;
    }

    public void setKeyWords(List<String> keyWords) {
        this.keyWords = keyWords;
    }

    public void setKeywords(String keywords) {
        this.keywords = keywords;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public void setModifydate(String modifydate) {
        this.modifydate = modifydate;
    }

    public void setPageSize(String pageSize) {
        this.pageSize = pageSize;
    }

    public void setPrintDate(Date printDate) {
        this.printDate = printDate;
    }

    public void setPrintdate(String printdate) {
        this.printdate = printdate;
    }

    public void setPrintedBy(String printedBy) {
        this.printedBy = printedBy;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public void setTemplate(DocumentTemplate template) {
        this.template = template;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(128);
        buf.append("title = '");
        buf.append(this.getTitle());
        buf.append("'");
        buf.append("\n");
        buf.append("author = '");
        buf.append(this.getAuthor());
        buf.append("'");
        buf.append("\n");
        buf.append("authors = '");
        buf.append(this.getAuthors());
        buf.append("'");
        buf.append("\n");
        buf.append("subject = '");
        buf.append(this.getSubject());
        buf.append("'");
        buf.append("\n");
        buf.append("keywords = '");
        buf.append(this.getKeywords());
        buf.append("'");
        buf.append("\n");
        buf.append("keyWords = '");
        buf.append(this.getKeyWords());
        buf.append("'");
        buf.append("\n");
        buf.append("pageSize = '");
        buf.append(this.getPageSize());
        buf.append("'");
        buf.append("\n");
        buf.append("generator = '");
        buf.append(this.getGenerator());
        buf.append("'");
        buf.append("\n");
        buf.append("description = '");
        buf.append(this.getDescription());
        buf.append("'");
        buf.append("\n");
        buf.append("initialCreator = '");
        buf.append(this.getInitialCreator());
        buf.append("'");
        buf.append("\n");
        buf.append("creator = '");
        buf.append(this.getCreator());
        buf.append("'");
        buf.append("\n");
        buf.append("printedBy = '");
        buf.append(this.getPrintedBy());
        buf.append("'");
        buf.append("\n");
        buf.append("creationDate = '");
        buf.append(this.getCreationDate());
        buf.append("'");
        buf.append("\n");
        buf.append("creationdate = '");
        buf.append(this.getCreationdate());
        buf.append("'");
        buf.append("\n");
        buf.append("date = '");
        buf.append(this.getDate());
        buf.append("'");
        buf.append("\n");
        buf.append("modifydate = '");
        buf.append(this.getModifydate());
        buf.append("'");
        buf.append("\n");
        buf.append("printDate = '");
        buf.append(this.getPrintDate());
        buf.append("'");
        buf.append("\n");
        buf.append("printdate = '");
        buf.append(this.getPrintdate());
        buf.append("'");
        buf.append("\n");
        buf.append("template = '");
        buf.append(this.getTemplate());
        buf.append("'");
        buf.append("\n");
        buf.append("hyperlinkBehaviour = '");
        buf.append(this.getHyperlinkBehaviour());
        buf.append("'");
        buf.append("\n");
        buf.append("language = '");
        buf.append(this.getLanguage());
        buf.append("'");
        buf.append("\n");
        buf.append("editingCycles = '");
        buf.append(this.getEditingCycles());
        buf.append("'");
        buf.append("\n");
        buf.append("editingDuration = '");
        buf.append(this.getEditingDuration());
        buf.append("'");
        buf.append("\n");
        buf.append("documentStatistic = '");
        buf.append(this.getDocumentStatistic());
        buf.append("'");
        buf.append("\n");
        buf.append("confidential = '");
        buf.append(this.isConfidential());
        buf.append("'");
        buf.append("\n");
        buf.append("draft = '");
        buf.append(this.isDraft());
        buf.append("'");
        return buf.toString();
    }

    public String getAllKeyWords() {
        String ret;
        StringBuffer sb = new StringBuffer();
        boolean hasKeywords = false;
        if (this.getKeywords() != null && this.getKeywords().trim().length() > 0) {
            StringTokenizer st = new StringTokenizer(this.getKeywords().trim(), ",");
            while (st.hasMoreTokens()) {
                String s = st.nextToken();
                sb.append(s.trim());
                if (st.hasMoreTokens()) {
                    sb.append(", ");
                }
                hasKeywords = true;
            }
        }
        if (this.getKeyWords() != null) {
            Iterator<String> it = this.getKeyWords().iterator();
            while (it.hasNext()) {
                String keyword = it.next();
                if (hasKeywords) {
                    sb.append(", ");
                    hasKeywords = false;
                }
                if (keyword.trim().length() <= 0) continue;
                sb.append(keyword.trim());
                if (!it.hasNext()) continue;
                sb.append(", ");
            }
        }
        if ((ret = sb.toString().trim()).endsWith(",")) {
            return ret.substring(0, ret.length() - 1);
        }
        return ret;
    }

    public String getAllAuthorNames() {
        StringBuffer sb = new StringBuffer();
        if (this.getAuthor() != null && this.getAuthor().trim().length() > 0) {
            return this.getAuthor().trim();
        }
        if (this.getAuthors() != null) {
            Iterator<DocumentAuthor> it = this.getAuthors().iterator();
            while (it.hasNext()) {
                DocumentAuthor author = it.next();
                sb.append(author.getFullName().trim());
                if (!it.hasNext()) continue;
                sb.append(", ");
            }
        }
        return sb.toString();
    }

    public String getCreationdate() {
        if (this.getCreationDate() != null) {
            return ISO_8601_FORMAT.format(this.getCreationDate());
        }
        return this.creationdate;
    }

    public String getModifydate() {
        if (this.getDate() != null) {
            return ISO_8601_FORMAT.format(this.getDate());
        }
        return this.modifydate;
    }

    public String getPrintdate() {
        if (this.getPrintDate() != null) {
            return ISO_8601_FORMAT.format(this.getPrintDate());
        }
        return this.printdate;
    }
}

