/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.views.memory;

import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IMemoryBlock;
import org.eclipse.debug.core.model.IMemoryBlockRetrieval;
import org.eclipse.debug.internal.ui.viewers.model.TreeModelContentProvider;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IModelDelta;
import org.eclipse.debug.internal.ui.viewers.model.provisional.TreeModelViewer;
import org.eclipse.debug.internal.ui.views.memory.MemoryView;

public class MemoryViewTreeModelContentProvider
extends TreeModelContentProvider {
    protected void updateNodes(IModelDelta[] nodes, int mask) {
        if (this.getViewer() instanceof TreeModelViewer) {
            int i = 0;
            while (i < nodes.length) {
                IModelDelta node = nodes[i];
                int flags = node.getFlags() & mask;
                if ((flags & 1) != 0 && node.getElement() instanceof IMemoryBlock) {
                    MemoryView view;
                    if ((flags & 0x200000) != 0 && this.getPresentationContext() instanceof MemoryView && (view = (MemoryView)this.getPresentationContext().getPart()).isPinMBDisplay()) {
                        flags |= 0x200000;
                        flags ^= 0x200000;
                    }
                    if (this.isFirstMemoryBlock()) {
                        flags |= 0x200000;
                    }
                }
                if ((flags & 1) != 0) {
                    this.handleAdd(node);
                }
                if ((flags & 2) != 0) {
                    this.handleRemove(node);
                }
                if ((flags & 0x400) != 0) {
                    this.handleContent(node);
                }
                if ((flags & 0x100000) != 0) {
                    this.handleExpand(node);
                }
                if ((flags & 0x200000) != 0) {
                    this.handleSelect(node);
                }
                if ((flags & 0x800) != 0) {
                    this.handleState(node);
                }
                if ((flags & 0x10) != 0) {
                    this.handleInsert(node);
                }
                if ((flags & 8) != 0) {
                    this.handleReplace(node);
                }
                if ((flags & 0x400000) != 0) {
                    this.handleInstall(node);
                }
                if ((flags & 0x800000) != 0) {
                    this.handleUninstall(node);
                }
                this.updateNodes(node.getChildDeltas(), mask);
                ++i;
            }
        }
    }

    private boolean isFirstMemoryBlock() {
        IMemoryBlock[] memoryBlocks;
        Object input = this.getViewer().getInput();
        return input instanceof IMemoryBlockRetrieval && (memoryBlocks = DebugPlugin.getDefault().getMemoryBlockManager().getMemoryBlocks((IMemoryBlockRetrieval)input)).length == 1;
    }
}

