/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.comma.signature.formatting2;

import com.google.inject.Inject;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import org.eclipse.comma.signature.interfaceSignature.Command;
import org.eclipse.comma.signature.interfaceSignature.InterfaceSignatureDefinition;
import org.eclipse.comma.signature.interfaceSignature.Notification;
import org.eclipse.comma.signature.interfaceSignature.Parameter;
import org.eclipse.comma.signature.interfaceSignature.Signal;
import org.eclipse.comma.signature.interfaceSignature.Signature;
import org.eclipse.comma.signature.services.InterfaceSignatureGrammarAccess;
import org.eclipse.comma.types.formatting2.TypesFormatter;
import org.eclipse.comma.types.types.Dimension;
import org.eclipse.comma.types.types.EnumElement;
import org.eclipse.comma.types.types.EnumTypeDecl;
import org.eclipse.comma.types.types.Import;
import org.eclipse.comma.types.types.RecordField;
import org.eclipse.comma.types.types.RecordTypeDecl;
import org.eclipse.comma.types.types.TypeDecl;
import org.eclipse.comma.types.types.TypesModel;
import org.eclipse.comma.types.types.VectorTypeConstructor;
import org.eclipse.comma.types.types.VectorTypeDecl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.formatting2.IFormattableDocument;
import org.eclipse.xtext.formatting2.regionaccess.ISemanticRegion;
import org.eclipse.xtext.formatting2.regionaccess.ISemanticRegionsFinder;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;
import org.eclipse.xtext.xbase.lib.Pair;

public class InterfaceSignatureFormatter
extends TypesFormatter {
    @Inject
    @Extension
    private InterfaceSignatureGrammarAccess _interfaceSignatureGrammarAccess;

    protected void _format(InterfaceSignatureDefinition interfaceDefinition, @Extension IFormattableDocument document) {
        Consumer<Import> _function = it -> document.format(it);
        interfaceDefinition.getImports().forEach(_function);
        document.format((Object)interfaceDefinition.getSignature());
    }

    protected void _format(Import _import, @Extension IFormattableDocument document) {
        this.formatTopElement((EObject)_import, document);
    }

    protected void _format(Signature _signature, @Extension IFormattableDocument document) {
        ISemanticRegionsFinder rFinder = this.textRegionExtensions.regionFor((EObject)_signature);
        this.formatTopElement((EObject)_signature, document);
        document.append(rFinder.keyword(this._interfaceSignatureGrammarAccess.getSignatureAccess().getSignatureKeyword_0()), TypesFormatter.oneSpace);
        ISemanticRegion kwTypes = rFinder.keyword(this._interfaceSignatureGrammarAccess.getSignatureAccess().getTypesKeyword_2_0());
        ISemanticRegion kwCommands = rFinder.keyword(this._interfaceSignatureGrammarAccess.getSignatureAccess().getCommandsKeyword_3_0());
        ISemanticRegion kwSignals = rFinder.keyword(this._interfaceSignatureGrammarAccess.getSignatureAccess().getSignalsKeyword_4_0());
        ISemanticRegion kwNotifications = rFinder.keyword(this._interfaceSignatureGrammarAccess.getSignatureAccess().getNotificationsKeyword_5_0());
        ISemanticRegion _xifexpression = null;
        if (kwTypes != null) {
            _xifexpression = kwTypes;
        } else {
            ISemanticRegion _xifexpression_1 = null;
            if (kwCommands != null) {
                _xifexpression_1 = kwCommands;
            } else {
                ISemanticRegion _xifexpression_2 = null;
                _xifexpression_2 = kwSignals != null ? kwSignals : kwNotifications;
                _xifexpression_1 = _xifexpression_2;
            }
            _xifexpression = _xifexpression_1;
        }
        ISemanticRegion kwFirst = _xifexpression;
        if (kwFirst != null) {
            document.set(kwFirst.getPreviousHiddenRegion(), this.textRegionExtensions.regionForEObject((EObject)IteratorExtensions.last((Iterator)_signature.eAllContents())).getNextHiddenRegion(), TypesFormatter.indent);
        }
        if (kwTypes != null) {
            document.prepend(kwTypes, TypesFormatter.newLine);
        }
        EList<TypeDecl> _types = _signature.getTypes();
        for (TypeDecl typeDecl : _types) {
            document.format((Object)typeDecl);
        }
        if (kwCommands != null) {
            document.prepend(kwCommands, TypesFormatter.emptyLine);
        }
        EList<Command> _commands = _signature.getCommands();
        for (Command command : _commands) {
            document.format((Object)command);
        }
        if (kwSignals != null) {
            document.prepend(kwSignals, TypesFormatter.emptyLine);
        }
        EList<Signal> _signals = _signature.getSignals();
        for (Signal signal : _signals) {
            document.format((Object)signal);
        }
        if (kwNotifications != null) {
            document.prepend(kwNotifications, TypesFormatter.emptyLine);
        }
        EList<Notification> _notifications = _signature.getNotifications();
        for (Notification notification : _notifications) {
            document.format((Object)notification);
        }
    }

    protected void _format(Command _command, @Extension IFormattableDocument document) {
        boolean _not;
        ISemanticRegionsFinder rFinder = this.textRegionExtensions.regionFor((EObject)_command);
        document.prepend((EObject)_command, TypesFormatter.newLine);
        document.append((EObject)_command.getType(), TypesFormatter.oneSpace);
        List pairs = rFinder.keywordPairs(this._interfaceSignatureGrammarAccess.getCommandAccess().getLeftParenthesisKeyword_2_0(), this._interfaceSignatureGrammarAccess.getCommandAccess().getRightParenthesisKeyword_2_3());
        boolean _isEmpty = pairs.isEmpty();
        boolean bl = _not = !_isEmpty;
        if (_not) {
            document.append(document.prepend((ISemanticRegion)((Pair)pairs.get(0)).getKey(), TypesFormatter.noSpace), TypesFormatter.noSpace);
            document.prepend((ISemanticRegion)((Pair)pairs.get(0)).getValue(), TypesFormatter.noSpace);
        }
        EList<Parameter> _parameters = _command.getParameters();
        for (Parameter param : _parameters) {
            document.format((Object)param);
        }
    }

    protected void _format(Notification _notification, @Extension IFormattableDocument document) {
        boolean _not;
        ISemanticRegionsFinder rFinder = this.textRegionExtensions.regionFor((EObject)_notification);
        document.prepend((EObject)_notification, TypesFormatter.newLine);
        List pairs = rFinder.keywordPairs(this._interfaceSignatureGrammarAccess.getNotificationAccess().getLeftParenthesisKeyword_1_0(), this._interfaceSignatureGrammarAccess.getNotificationAccess().getRightParenthesisKeyword_1_3());
        boolean _isEmpty = pairs.isEmpty();
        boolean bl = _not = !_isEmpty;
        if (_not) {
            document.append(document.prepend((ISemanticRegion)((Pair)pairs.get(0)).getKey(), TypesFormatter.noSpace), TypesFormatter.noSpace);
            document.prepend((ISemanticRegion)((Pair)pairs.get(0)).getValue(), TypesFormatter.noSpace);
        }
        EList<Parameter> _parameters = _notification.getParameters();
        for (Parameter param : _parameters) {
            document.format((Object)param);
        }
    }

    protected void _format(Signal _signal, @Extension IFormattableDocument document) {
        ISemanticRegionsFinder rFinder = this.textRegionExtensions.regionFor((EObject)_signal);
        document.prepend((EObject)_signal, TypesFormatter.newLine);
        document.append(document.prepend(rFinder.keyword(this._interfaceSignatureGrammarAccess.getSignalAccess().getLeftParenthesisKeyword_1_0()), TypesFormatter.noSpace), TypesFormatter.noSpace);
        document.prepend(rFinder.keyword(this._interfaceSignatureGrammarAccess.getSignalAccess().getRightParenthesisKeyword_1_3()), TypesFormatter.noSpace);
        EList<Parameter> _parameters = _signal.getParameters();
        for (Parameter param : _parameters) {
            document.format((Object)param);
        }
    }

    protected void _format(Parameter _parameter, @Extension IFormattableDocument document) {
        ISemanticRegionsFinder rFinder = this.textRegionExtensions.regionFor((EObject)_parameter);
        ISemanticRegion _ruleCall = rFinder.ruleCall(this._interfaceSignatureGrammarAccess.getParameterAccess().getDirectionDIRECTIONEnumRuleCall_0_0());
        if (_ruleCall != null) {
            document.append(_ruleCall, TypesFormatter.oneSpace);
        }
        document.append((EObject)_parameter.getType(), TypesFormatter.oneSpace);
    }

    public void format(Object _command, IFormattableDocument document) {
        if (_command instanceof Command) {
            this._format((Command)_command, document);
            return;
        }
        if (_command instanceof Notification) {
            this._format((Notification)_command, document);
            return;
        }
        if (_command instanceof Signal) {
            this._format((Signal)_command, document);
            return;
        }
        if (_command instanceof EnumTypeDecl) {
            this._format((EnumTypeDecl)_command, document);
            return;
        }
        if (_command instanceof RecordTypeDecl) {
            this._format((RecordTypeDecl)_command, document);
            return;
        }
        if (_command instanceof VectorTypeDecl) {
            this._format((VectorTypeDecl)_command, document);
            return;
        }
        if (_command instanceof XtextResource) {
            this._format((XtextResource)_command, document);
            return;
        }
        if (_command instanceof InterfaceSignatureDefinition) {
            this._format((InterfaceSignatureDefinition)_command, document);
            return;
        }
        if (_command instanceof Parameter) {
            this._format((Parameter)_command, document);
            return;
        }
        if (_command instanceof Signature) {
            this._format((Signature)_command, document);
            return;
        }
        if (_command instanceof EnumElement) {
            this._format((EnumElement)_command, document);
            return;
        }
        if (_command instanceof RecordField) {
            this._format((RecordField)_command, document);
            return;
        }
        if (_command instanceof TypeDecl) {
            this._format((TypeDecl)_command, document);
            return;
        }
        if (_command instanceof TypesModel) {
            this._format((TypesModel)_command, document);
            return;
        }
        if (_command instanceof VectorTypeConstructor) {
            this._format((VectorTypeConstructor)_command, document);
            return;
        }
        if (_command instanceof Dimension) {
            this._format((Dimension)_command, document);
            return;
        }
        if (_command instanceof Import) {
            this._format((Import)_command, document);
            return;
        }
        if (_command instanceof EObject) {
            this._format((EObject)_command, document);
            return;
        }
        if (_command == null) {
            this._format(null, document);
            return;
        }
        if (_command != null) {
            this._format(_command, document);
            return;
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(_command, document).toString());
    }
}

