/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.runtime.mail;

import java.lang.reflect.Method;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.dirigible.repository.logging.Logger;
import org.eclipse.dirigible.runtime.scripting.IMailService;

public class MailSenderProvidedService
implements IMailService {
    private static final String MAIL_SERVICE_IS_NOT_AVAILABLE = "Mail Service (Provided) is not available";
    private HttpServletRequest request;
    private static final Logger logger = Logger.getLogger((String)MailSenderProvidedService.class.getCanonicalName());

    MailSenderProvidedService(HttpServletRequest request) {
        this.request = request;
    }

    @Override
    public String sendMail(String from, String to, String subject, String content) {
        try {
            Object providedMailSender = System.getProperties().get("MailSessionProvided");
            if (providedMailSender == null && this.request != null) {
                providedMailSender = this.request.getSession().getAttribute("MailSessionProvided");
            }
            if (providedMailSender == null) {
                throw new Exception(MAIL_SERVICE_IS_NOT_AVAILABLE);
            }
            Method method = providedMailSender.getClass().getMethod("sendMail", String.class, String.class, String.class, String.class);
            return (String)method.invoke(providedMailSender, from, to, subject, content);
        }
        catch (Exception e) {
            logger.error(String.valueOf(this.getClass().getCanonicalName()) + "#sendMail()", (Throwable)e);
            return e.getMessage();
        }
    }
}

