/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.runtime.registry;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.MissingResourceException;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.eclipse.dirigible.repository.api.ContentTypeHelper;
import org.eclipse.dirigible.repository.api.ICollection;
import org.eclipse.dirigible.repository.api.IEntity;
import org.eclipse.dirigible.repository.api.IResource;
import org.eclipse.dirigible.repository.logging.Logger;
import org.eclipse.dirigible.runtime.registry.Messages;
import org.eclipse.dirigible.runtime.registry.RegistryServlet;

public class RepositoryServlet
extends RegistryServlet {
    private static final String REQUEST_PROCESSING_FAILED_S = Messages.getString("RepositoryServlet.REQUEST_PROCESSING_FAILED_S");
    private static final String THERE_IS_AN_EXISTING_COLLECTION_AT_THE_SAME_LOCATION = Messages.getString("RepositoryServlet.THERE_IS_AN_EXISTING_COLLECTION_AT_THE_SAME_LOCATION");
    private static final String THERE_IS_AN_EXISTING_RESOURCE_AT_THE_SAME_LOCATION_USE_PUT_METHOD_FOR_UPDATE = Messages.getString("RepositoryServlet.THERE_IS_AN_EXISTING_RESOURCE_AT_THE_SAME_LOCATION_USE_PUT_METHOD_FOR_UPDATE");
    private static final long serialVersionUID = 726309327921007381L;
    private static final Logger logger = Logger.getLogger(RepositoryServlet.class);

    @Override
    protected String getRepositoryPathPrefix(HttpServletRequest req) {
        return "";
    }

    @Override
    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        super.doGet(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String repositoryPath = null;
        ServletOutputStream out = response.getOutputStream();
        try {
            try {
                repositoryPath = this.extractRepositoryPath(request);
                IEntity entity = this.getEntity(repositoryPath, request);
                if (entity == null) {
                    ByteArrayOutputStream buff = new ByteArrayOutputStream();
                    IOUtils.copy((InputStream)request.getInputStream(), (OutputStream)buff);
                    byte[] data = buff.toByteArray();
                    String contentType = request.getContentType();
                    if (contentType == null) {
                        contentType = "text/plain";
                    }
                    boolean isBinary = ContentTypeHelper.isBinary((String)contentType);
                    this.getRepository(request).createResource(repositoryPath, data, isBinary, contentType);
                } else if (entity instanceof IResource) {
                    response.sendError(400, THERE_IS_AN_EXISTING_RESOURCE_AT_THE_SAME_LOCATION_USE_PUT_METHOD_FOR_UPDATE);
                } else if (entity instanceof ICollection) {
                    response.sendError(400, THERE_IS_AN_EXISTING_COLLECTION_AT_THE_SAME_LOCATION);
                }
            }
            catch (IllegalArgumentException ex) {
                logger.error(String.valueOf(String.format(REQUEST_PROCESSING_FAILED_S, repositoryPath)) + ex.getMessage(), (Throwable)ex);
                response.sendError(400, ex.getMessage());
                out.flush();
                out.close();
            }
            catch (MissingResourceException ex) {
                logger.error(String.valueOf(String.format(REQUEST_PROCESSING_FAILED_S, repositoryPath)) + ex.getMessage(), (Throwable)ex);
                response.sendError(204, ex.getMessage());
                out.flush();
                out.close();
            }
        }
        finally {
            out.flush();
            out.close();
        }
    }

    protected void doPut(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String repositoryPath = null;
        ServletOutputStream out = response.getOutputStream();
        try {
            try {
                repositoryPath = this.extractRepositoryPath(request);
                IEntity entity = this.getEntity(repositoryPath, request);
                if (entity == null) {
                    this.doPost(request, response);
                } else if (entity instanceof IResource) {
                    ByteArrayOutputStream buff = new ByteArrayOutputStream();
                    IOUtils.copy((InputStream)request.getInputStream(), (OutputStream)buff);
                    byte[] data = buff.toByteArray();
                    IResource resource = (IResource)entity;
                    resource.setContent(data);
                } else {
                    response.sendError(400, THERE_IS_AN_EXISTING_COLLECTION_AT_THE_SAME_LOCATION);
                }
            }
            catch (IllegalArgumentException ex) {
                logger.error(String.valueOf(String.format(REQUEST_PROCESSING_FAILED_S, repositoryPath)) + ex.getMessage(), (Throwable)ex);
                response.sendError(400, ex.getMessage());
                out.flush();
                out.close();
            }
            catch (MissingResourceException ex) {
                logger.error(String.valueOf(String.format(REQUEST_PROCESSING_FAILED_S, repositoryPath)) + ex.getMessage(), (Throwable)ex);
                response.sendError(204, ex.getMessage());
                out.flush();
                out.close();
            }
        }
        finally {
            out.flush();
            out.close();
        }
    }

    protected void doDelete(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String repositoryPath = null;
        ServletOutputStream out = response.getOutputStream();
        try {
            try {
                repositoryPath = this.extractRepositoryPath(request);
                IEntity entity = this.getEntity(repositoryPath, request);
                if (entity != null) {
                    this.getRepository(request).removeResource(repositoryPath);
                }
            }
            catch (IllegalArgumentException ex) {
                logger.error(String.valueOf(String.format(REQUEST_PROCESSING_FAILED_S, repositoryPath)) + ex.getMessage(), (Throwable)ex);
                response.sendError(400, ex.getMessage());
                out.flush();
                out.close();
            }
            catch (MissingResourceException ex) {
                logger.error(String.valueOf(String.format(REQUEST_PROCESSING_FAILED_S, repositoryPath)) + ex.getMessage(), (Throwable)ex);
                response.sendError(204, ex.getMessage());
                out.flush();
                out.close();
            }
        }
        finally {
            out.flush();
            out.close();
        }
    }
}

