/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.runtime.search;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;
import java.util.MissingResourceException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.lucene.index.IndexNotFoundException;
import org.eclipse.dirigible.repository.api.IRepository;
import org.eclipse.dirigible.repository.ext.indexing.RepositoryMemoryIndexer;
import org.eclipse.dirigible.repository.logging.Logger;
import org.eclipse.dirigible.runtime.registry.AbstractRegistryServlet;

public class SearchServlet
extends AbstractRegistryServlet {
    private static final String REQUEST_PROCESSING_FAILED_S = "";
    private static final String SEARCH_TERM = "q";
    private static final String REINDEX = "reindex";
    private static final long serialVersionUID = 7435479651482177443L;
    private static final Logger logger = Logger.getLogger(SearchServlet.class);

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String searchTerm = request.getParameter(SEARCH_TERM);
        try {
            IRepository repository = this.getRepository(request);
            String reindex = request.getParameter(REINDEX);
            if (reindex != null) {
                RepositoryMemoryIndexer.clearIndex();
                RepositoryMemoryIndexer.indexRepository((IRepository)repository);
                response.getWriter().println("0");
                return;
            }
            response.setContentType("application/json");
            if (searchTerm == null || REQUEST_PROCESSING_FAILED_S.equals(searchTerm)) {
                response.getWriter().println("[]");
                return;
            }
            List paths = null;
            try {
                paths = RepositoryMemoryIndexer.search((String)searchTerm);
            }
            catch (IndexNotFoundException indexNotFoundException) {
                RepositoryMemoryIndexer.indexRepository((IRepository)repository);
            }
            paths = RepositoryMemoryIndexer.search((String)searchTerm);
            this.enumeratePaths(request, response, paths);
        }
        catch (IllegalArgumentException ex) {
            logger.error(String.valueOf(String.format(REQUEST_PROCESSING_FAILED_S, searchTerm)) + ex.getMessage(), (Throwable)ex);
            response.sendError(400, ex.getMessage());
        }
        catch (MissingResourceException ex) {
            logger.error(String.valueOf(String.format(REQUEST_PROCESSING_FAILED_S, searchTerm)) + ex.getMessage(), (Throwable)ex);
            response.sendError(204, ex.getMessage());
        }
    }

    private void enumeratePaths(HttpServletRequest request, HttpServletResponse response, List<String> paths) throws IOException {
        PrintWriter writer = response.getWriter();
        String collectionPath = this.getContentLocationPrefix();
        JsonArray rootArray = new JsonArray();
        for (String entity : paths) {
            String deployPrefix;
            String entityName = entity;
            if (!entityName.startsWith(deployPrefix = this.getContentDeployPrefix(request))) continue;
            entityName = entityName.substring(deployPrefix.length());
            String path = String.valueOf(collectionPath) + entityName;
            JsonObject elementObject = new JsonObject();
            elementObject.addProperty("name", entityName);
            elementObject.addProperty("path", path);
            rootArray.add((JsonElement)elementObject);
        }
        writer.println(new Gson().toJson((JsonElement)rootArray));
        writer.flush();
        writer.close();
    }

    protected String getContentDeployPrefix(HttpServletRequest req) {
        return "/db/dirigible/registry/public";
    }

    protected String getContentLocationPrefix() {
        return "../registry";
    }
}

