/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ui.workbench.renderers.base.addons;

import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.di.UISynchronize;
import org.eclipse.e4.ui.model.application.ui.MElementContainer;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.advanced.MArea;
import org.eclipse.e4.ui.model.application.ui.advanced.MPlaceholder;
import org.eclipse.e4.ui.model.application.ui.basic.MPartSashContainer;
import org.eclipse.e4.ui.model.application.ui.basic.MPartSashContainerElement;
import org.eclipse.e4.ui.model.application.ui.basic.MPartStack;
import org.eclipse.e4.ui.model.application.ui.basic.MStackElement;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.fx.ui.workbench.renderers.base.widget.WDragSourceWidget;
import org.eclipse.fx.ui.workbench.renderers.base.widget.WDragTargetWidget;
import org.eclipse.fx.ui.workbench.renderers.base.widget.WStack;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.osgi.service.event.Event;

public class DnDAddon {
    private static String CSS_CLASS_STACK_MOVE = "stack-move";
    @Inject
    IEventBroker eventBroker;
    @Inject
    EPartService partService;
    @Inject
    UISynchronize synchronize;
    @Inject
    EModelService modelService;
    private Timer timer = new Timer(true);

    private WDragTargetWidget getTargetWidget(MUIElement changedElement) {
        if (changedElement instanceof MPlaceholder) {
            return this.getTargetWidget(((MPlaceholder)changedElement).getRef());
        }
        if (changedElement.getWidget() instanceof WDragTargetWidget) {
            return (WDragTargetWidget)changedElement.getWidget();
        }
        return null;
    }

    private WStack<?, ?, ?> getSourceWidget(MUIElement changedElement) {
        if (changedElement instanceof MPlaceholder) {
            return this.getSourceWidget(((MPlaceholder)changedElement).getRef());
        }
        if (changedElement.getWidget() instanceof WDragSourceWidget) {
            return (WStack)changedElement.getWidget();
        }
        return null;
    }

    private void handleWidget(Event event) {
        MUIElement changedElement = (MUIElement)event.getProperty("ChangedElement");
        WDragTargetWidget acceptWidget = this.getTargetWidget(changedElement);
        if (acceptWidget != null) {
            acceptWidget.setDragDroppedCallback(this::droppedHandler);
        }
        if (!(changedElement instanceof MPartStack) && !(changedElement instanceof MArea)) {
            return;
        }
        WStack<?, ?, ?> sourceWidget = this.getSourceWidget(changedElement);
        if (sourceWidget != null) {
            sourceWidget.setDragStartCallback(this::dragStartHandler);
        }
    }

    private Void droppedHandler(WDragTargetWidget.DropData d) {
        @Nullable MUIElement reference = d.reference;
        @NonNull MUIElement sourceElement = d.sourceElement;
        switch (d.dropType) {
            case BEFORE: 
            case AFTER: {
                if (reference == null) break;
                this.handleReorder(reference, sourceElement, d.dropType);
                break;
            }
            case INSERT: {
                if (reference == null) break;
                DnDAddon.handleInsert(reference, sourceElement);
                break;
            }
            case SPLIT_TOP: 
            case SPLIT_BOTTOM: 
            case SPLIT_LEFT: 
            case SPLIT_RIGHT: {
                if (reference == null) break;
                this.handleSplit(reference, sourceElement, d.dropType);
                break;
            }
        }
        return null;
    }

    private static void handleInsert(@NonNull MUIElement reference, @NonNull MUIElement sourceElement) {
        if (reference instanceof MElementContainer) {
            MElementContainer c = (MElementContainer)reference;
            c.getChildren().add(sourceElement);
        }
    }

    private void handleSplit(@NonNull MUIElement reference, @NonNull MUIElement sourceElement, @NonNull WDragTargetWidget.DropType dropType) {
        MElementContainer parent = reference.getParent();
        if (parent instanceof MPartStack) {
            this.split((MUIElement)parent, sourceElement, dropType);
        }
    }

    private void split(MUIElement toSplit, MUIElement child, @NonNull WDragTargetWidget.DropType dropType) {
        child.setParent(null);
        MElementContainer owner = toSplit.getParent();
        int index = owner.getChildren().indexOf(toSplit);
        owner.getChildren().remove(toSplit);
        MPartSashContainer container = (MPartSashContainer)this.modelService.createModelElement(MPartSashContainer.class);
        container.setContainerData(toSplit.getContainerData());
        MPartStack childContainer = (MPartStack)this.modelService.createModelElement(MPartStack.class);
        childContainer.getChildren().add((MStackElement)child);
        toSplit.setContainerData(null);
        childContainer.setContainerData(null);
        container.setToBeRendered(true);
        container.setVisible(true);
        container.setHorizontal(dropType == WDragTargetWidget.DropType.SPLIT_LEFT || dropType == WDragTargetWidget.DropType.SPLIT_RIGHT);
        if (dropType == WDragTargetWidget.DropType.SPLIT_TOP || dropType == WDragTargetWidget.DropType.SPLIT_LEFT) {
            container.getChildren().add(childContainer);
            container.getChildren().add((MPartSashContainerElement)toSplit);
        } else {
            container.getChildren().add((MPartSashContainerElement)toSplit);
            container.getChildren().add(childContainer);
        }
        owner.getChildren().add(index, container);
    }

    private void handleReorder(@NonNull MUIElement reference, final @NonNull MUIElement sourceElement, @NonNull WDragTargetWidget.DropType dropType) {
        MElementContainer targetContainer;
        MElementContainer sourceContainer = sourceElement.getParent();
        if (sourceContainer == (targetContainer = reference.getParent())) {
            try {
                targetContainer.getTags().add(CSS_CLASS_STACK_MOVE);
                sourceElement.getTransientData().put("fx.rendering.stackitem.move", Boolean.TRUE);
                List children = targetContainer.getChildren();
                children.remove(sourceElement);
                int idx = targetContainer.getChildren().indexOf(reference);
                if (dropType == WDragTargetWidget.DropType.AFTER) {
                    ++idx;
                }
                if (idx > targetContainer.getChildren().size()) {
                    targetContainer.getChildren().add(sourceElement);
                }
                targetContainer.getChildren().add(idx, sourceElement);
            }
            finally {
                sourceElement.getTransientData().put("fx.rendering.stackitem.move", Boolean.TRUE);
                targetContainer.getTags().remove(CSS_CLASS_STACK_MOVE);
            }
        } else {
            int idx = targetContainer.getChildren().indexOf(reference);
            if (dropType == WDragTargetWidget.DropType.AFTER) {
                ++idx;
            }
            if (idx < targetContainer.getChildren().size()) {
                targetContainer.getChildren().add(idx, sourceElement);
            } else {
                targetContainer.getChildren().add(sourceElement);
            }
        }
        TimerTask t = new TimerTask(){

            @Override
            public void run() {
                DnDAddon.this.synchronize.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        targetContainer.setSelectedElement(sourceElement);
                    }
                });
            }
        };
        this.timer.schedule(t, 200L);
    }

    private @NonNull Boolean dragStartHandler(@NonNull WDragSourceWidget.DragData d) {
        return Boolean.TRUE;
    }

    @PostConstruct
    void hookListeners() {
        this.eventBroker.subscribe("org/eclipse/e4/ui/model/ui/UIElement/widget/*", this::handleWidget);
    }
}

