/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ui.workbench.base.restart;

import javax.inject.Inject;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.e4.core.di.annotations.Creatable;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.di.extensions.Preference;
import org.eclipse.fx.core.log.Log;
import org.eclipse.fx.core.log.Logger;
import org.osgi.service.prefs.BackingStoreException;

@Creatable
public class RestartPreferenceUtil {
    static final String CLEAR_STATE_AFTER_RESTART = "CLEAR_STATE_AFTER_RESTART";
    @Inject
    @Preference
    private IEclipsePreferences node;
    @Inject
    @Optional
    @Preference(value="CLEAR_STATE_AFTER_RESTART")
    private boolean clearPersistedStateAfterRestart;
    @Inject
    @Log
    Logger logger;

    public void setClearPersistedStateOnRestart(boolean value) {
        this.node.putBoolean(CLEAR_STATE_AFTER_RESTART, value);
        try {
            this.node.flush();
        }
        catch (BackingStoreException e) {
            this.logger.error("Error while writing preferences", (Throwable)e);
        }
    }

    public boolean isClearPersistedStateOnRestart() {
        return this.clearPersistedStateAfterRestart;
    }
}

