/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ui.preferences.page;

import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import javafx.beans.value.ObservableValue;
import javafx.scene.control.ColorPicker;
import javafx.scene.paint.Color;
import org.eclipse.fx.core.log.Logger;
import org.eclipse.fx.core.log.LoggerCreator;
import org.eclipse.fx.ui.preferences.page.FieldEditor;

public class ColorFieldEditor
extends FieldEditor<Color> {
    private static final Logger LOGGER = LoggerCreator.createLogger(ColorFieldEditor.class);
    private final ColorPicker colorPicker = new ColorPicker();

    public ColorFieldEditor(String name, String label) {
        super(name, label);
        this.getChildren().add((Object)this.colorPicker);
    }

    public ColorFieldEditor(String name) {
        this(name, null);
    }

    @Override
    protected void doLoad() {
        String color = this.getMemento().get(this.getName(), "");
        this.colorPicker.setValue((Object)this.parseColor(color));
    }

    @Override
    protected void doRestoreDefaults() {
        String defaultColor = this.getMemento().getDefaultString(this.getName());
        this.colorPicker.setValue((Object)this.parseColor(defaultColor));
    }

    private Color parseColor(String color) {
        if (color == null || color.isEmpty()) {
            return null;
        }
        StringTokenizer tokenizer = new StringTokenizer(color, ",");
        try {
            String red = tokenizer.nextToken().trim();
            String green = tokenizer.nextToken().trim();
            String blue = tokenizer.nextToken().trim();
            String alpha = tokenizer.hasMoreTokens() ? tokenizer.nextToken() : "1.0";
            try {
                int r = Integer.parseInt(red);
                int g = Integer.parseInt(green);
                int b = Integer.parseInt(blue);
                double a = Double.parseDouble(alpha);
                return new Color(ColorFieldEditor.toDouble(r), ColorFieldEditor.toDouble(g), ColorFieldEditor.toDouble(b), a);
            }
            catch (Exception ex) {
                LOGGER.error("An error occurred when trying to load the color value for " + this.getName(), (Throwable)ex);
            }
        }
        catch (IllegalArgumentException ex) {
            LOGGER.error("An error occurred when trying to load the color value for " + this.getName(), (Throwable)ex);
        }
        catch (NoSuchElementException ex) {
            LOGGER.error("An error occurred when trying to load the color value for " + this.getName(), (Throwable)ex);
        }
        return null;
    }

    private static double toDouble(int intColor) {
        return (double)intColor / 255.0;
    }

    @Override
    protected void doPersist() {
        Color color = (Color)this.colorPicker.getValue();
        this.getMemento().put(this.getName(), ColorFieldEditor.toString(color));
    }

    private static String toString(Color color) {
        return String.format("%s,%s,%s,%s", ColorFieldEditor.toInt(color.getRed()), ColorFieldEditor.toInt(color.getGreen()), ColorFieldEditor.toInt(color.getBlue()), color.getOpacity());
    }

    private static int toInt(double color) {
        return (int)Math.round(color * 255.0);
    }

    @Override
    public ObservableValue<Color> getValue() {
        return this.colorPicker.valueProperty();
    }

    protected final ColorPicker getColorPicker() {
        return this.colorPicker;
    }
}

