/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.internal.index;

import java.util.Comparator;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.m2e.core.internal.index.IndexedArtifactFile;

public class IndexedArtifact
implements Comparable<IndexedArtifact> {
    public static final Comparator<IndexedArtifactFile> FILE_INFO_COMPARATOR = Comparator.comparing(IndexedArtifactFile::getArtifactVersion).reversed().thenComparing(f -> f.classifier, Comparator.nullsFirst(Comparator.naturalOrder()));
    private final String group;
    private final String artifact;
    private final String packageName;
    private final String className;
    private final String packaging;
    private static final int SEED = 17;
    private final Set<IndexedArtifactFile> files = new TreeSet<IndexedArtifactFile>(FILE_INFO_COMPARATOR);

    public IndexedArtifact(String group, String artifact, String packageName, String className, String packaging) {
        this.group = group;
        this.artifact = artifact;
        this.packageName = packageName;
        this.className = className;
        this.packaging = packaging;
    }

    public void addFile(IndexedArtifactFile indexedArtifactFile) {
        this.getFiles().add(indexedArtifactFile);
    }

    public String getPackageName() {
        if (this.packageName != null && this.packageName.startsWith(".") && this.packageName.length() > 1) {
            return this.packageName.substring(1);
        }
        return this.packageName;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("\n" + this.getClassname() + "  " + this.packageName + "  " + this.getGroupId() + " : " + this.getArtifactId());
        return sb.toString();
    }

    public String getGroupId() {
        return this.group;
    }

    public String getArtifactId() {
        return this.artifact;
    }

    public String getPackaging() {
        return this.packaging;
    }

    public String getClassname() {
        return this.className;
    }

    public Set<IndexedArtifactFile> getFiles() {
        return this.files;
    }

    public int hashCode() {
        int result = 17;
        result *= this.fieldHash(this.getGroupId());
        result *= this.fieldHash(this.getArtifactId());
        result *= this.fieldHash(this.getPackaging());
        result *= this.fieldHash(this.getClassname());
        return result *= this.fieldHash(this.getPackageName());
    }

    private int fieldHash(Object field) {
        if (field == null) {
            return 17;
        }
        return field.hashCode();
    }

    public boolean equals(Object artifact) {
        if (this == artifact) {
            return true;
        }
        if (!(artifact instanceof IndexedArtifact)) {
            return false;
        }
        IndexedArtifact other = (IndexedArtifact)artifact;
        return this.fieldsEqual(this.getGroupId(), other.getGroupId()) && this.fieldsEqual(this.getArtifactId(), other.getArtifactId()) && this.fieldsEqual(this.getPackageName(), other.getPackageName()) && this.fieldsEqual(this.getPackaging(), other.getPackaging()) && this.fieldsEqual(this.getClassname(), other.getClassname());
    }

    private boolean fieldsEqual(Object field1, Object field2) {
        return field1 == null ? field2 == null : field1.equals(field2);
    }

    @Override
    public int compareTo(IndexedArtifact o) {
        if (this.equals(o)) {
            return 0;
        }
        int comparison = 0;
        if (this.group != null && (comparison = this.group.compareTo(o.getGroupId())) != 0) {
            return comparison;
        }
        if (this.artifact != null && (comparison = this.artifact.compareTo(o.getArtifactId())) != 0) {
            return comparison;
        }
        if (this.packageName != null && (comparison = this.packageName.compareTo(o.getPackageName())) != 0) {
            return comparison;
        }
        if (this.className != null && (comparison = this.className.compareTo(o.getClassname())) != 0) {
            return comparison;
        }
        return 0;
    }
}

