/**
 * Copyright (c) 2015 CEA LIST.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 * 
 * Contributors:
 *     CEA LIST - initial API and implementation
 */
package org.eclipse.papyrus.designer.languages.c.codegen.lib;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.papyrus.designer.languages.common.base.GenUtils;
import org.eclipse.papyrus.designer.languages.common.profile.Codegen.NoCodeGen;
import org.eclipse.uml2.common.util.UML2Util;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.InterfaceRealization;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

@SuppressWarnings("all")
public class InterfaceScript {
  public static Iterable<EList<NamedElement>> getInterfaceRealizationClass(final Classifier classifier) {
    final Function1<EStructuralFeature.Setting, Boolean> _function = new Function1<EStructuralFeature.Setting, Boolean>() {
      @Override
      public Boolean apply(final EStructuralFeature.Setting it) {
        return Boolean.valueOf(((it instanceof InterfaceRealization) && (!GenUtils.hasStereotypeTree(((Element) it), NoCodeGen.class))));
      }
    };
    final Function1<EStructuralFeature.Setting, EList<NamedElement>> _function_1 = new Function1<EStructuralFeature.Setting, EList<NamedElement>>() {
      @Override
      public EList<NamedElement> apply(final EStructuralFeature.Setting it) {
        return ((InterfaceRealization) it).getClients();
      }
    };
    return IterableExtensions.<EStructuralFeature.Setting, EList<NamedElement>>map(IterableExtensions.<EStructuralFeature.Setting>filter(UML2Util.getInverseReferences(classifier), _function), _function_1);
  }
}
