/*******************************************************************************
 * Copyright (c) 2006 - 2012 CEA LIST.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 *     CEA LIST - initial API and implementation
 *******************************************************************************/

package org.eclipse.papyrus.designer.languages.c.codegen.preferences;

import java.util.regex.Pattern;

public class CCodeGenConstants {

	/**
	 * Suffix for generated header files
	 */
	public static final String P_HEADER_SUFFIX = "headSuffix"; //$NON-NLS-1$

	/**
	 * Suffix for generated body/implementation files
	 */
	public static final String P_IMPLEM_SUFFIX = "implSuffix"; //$NON-NLS-1$

	/**
	 * Suffix for generated body/implementation files
	 */
	public static final String P_OUT_INOUT_OP = "outInoutOp"; //$NON-NLS-1$

	/**
	 * User defined comment header in generated files
	 */
	public static final String P_COMMENT_HEADER = "commentHeader"; //$NON-NLS-1$

	/**
	 * If true (default), format the generated code
	 */
	public static final String P_FORMAT_CODE = "formatCode"; //$NON-NLS-1$

	/**
	 * Suffix for generated header files
	 */
	public static final String P_PROJECT_PREFIX = "projectPrefix"; //$NON-NLS-1$
	
	/**
	 *  Supported languages: "C/C++", "c", and "C". The '+' needs to be escaped in a regular expression
	 */
	public static final Pattern supportedLanguages = Pattern.compile("C/C\\+\\+|c|C"); //$NON-NLS-1$
}
