/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.designer.languages.cpp.cdt.texteditor.editor;

import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.IParent;
import org.eclipse.cdt.core.model.ISourceRange;
import org.eclipse.cdt.core.model.ISourceReference;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.internal.ui.editor.CEditor;
import org.eclipse.cdt.ui.CDTUITools;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.papyrus.designer.languages.cpp.cdt.texteditor.Activator;
import org.eclipse.papyrus.designer.languages.cpp.cdt.texteditor.sync.ObtainICElement;
import org.eclipse.papyrus.designer.languages.cpp.cdt.texteditor.sync.SyncCDTtoModel;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;
import org.eclipse.papyrus.infra.ui.editor.IMultiDiagramEditor;
import org.eclipse.papyrus.infra.ui.lifecycleevents.DoSaveEvent;
import org.eclipse.papyrus.infra.ui.lifecycleevents.ILifeCycleEventsProvider;
import org.eclipse.papyrus.infra.ui.lifecycleevents.ISaveEventListener;
import org.eclipse.papyrus.infra.ui.services.EditorLifecycleEventListener;
import org.eclipse.papyrus.infra.ui.services.EditorLifecycleManager;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IEditorInput;
import org.eclipse.uml2.uml.NamedElement;

public class SyncCDTEditor
extends CEditor {
    protected ILifeCycleEventsProvider lifeCycleEvents;
    protected ISaveEventListener preSaveEvent;
    protected FocusListener focusListener;
    protected SyncCDTtoModel syncCpp;
    protected Composite syncBar;
    public static final RGB ORANGE = new RGB(240, 150, 100);
    public static final RGB GREEN = new RGB(150, 230, 100);

    public void setEditorData(ServicesRegistry registry, SyncCDTtoModel syncCpp) {
        try {
            this.syncCpp = syncCpp;
            this.lifeCycleEvents = (ILifeCycleEventsProvider)registry.getService(ILifeCycleEventsProvider.class);
            this.syncBar.setBackground(new Color((Device)Display.getDefault(), GREEN));
            this.preSaveEvent = new ISaveEventListener(){

                public void doSaveAs(DoSaveEvent event) {
                }

                public void doSave(DoSaveEvent event) {
                    SyncCDTEditor.this.syncCpp.syncCDTtoModel();
                }
            };
            this.lifeCycleEvents.addAboutToDoSaveListener(this.preSaveEvent);
            EditorLifecycleManager editorlifeCycle = (EditorLifecycleManager)registry.getService(EditorLifecycleManager.class);
            EditorLifecycleEventListener closeListener = new EditorLifecycleEventListener(){

                public void postInit(IMultiDiagramEditor editor) {
                }

                public void postDisplay(IMultiDiagramEditor editor) {
                }

                public void beforeClose(IMultiDiagramEditor editor) {
                    SyncCDTEditor.this.syncCpp = null;
                    SyncCDTEditor.this.syncBar.setBackground(new Color((Device)Display.getDefault(), ORANGE));
                }
            };
            editorlifeCycle.addEditorLifecycleEventsListener(closeListener);
        }
        catch (ServiceException e) {
            Activator.log.error((Throwable)e);
        }
    }

    public ISourceViewer createSourceViewer(Composite parent, IVerticalRuler ruler, int styles) {
        parent.setLayout((Layout)new GridLayout(2, false));
        this.syncBar = new Composite(parent, 0);
        GridData barGD = new GridData();
        barGD.widthHint = 5;
        barGD.verticalAlignment = 4;
        this.syncBar.setLayoutData((Object)barGD);
        ISourceViewer viewer = super.createSourceViewer(parent, ruler, styles);
        GridData editorGD = new GridData();
        editorGD.horizontalAlignment = 4;
        editorGD.verticalAlignment = 4;
        editorGD.grabExcessHorizontalSpace = true;
        editorGD.grabExcessVerticalSpace = true;
        parent.getChildren()[1].setLayoutData((Object)editorGD);
        this.syncBar.setBackground(new Color((Device)Display.getDefault(), ORANGE));
        parent.pack();
        this.focusListener = new FocusListener(){

            public void focusLost(FocusEvent e) {
                if (SyncCDTEditor.this.isDirty() && SyncCDTEditor.this.syncCpp != null) {
                    SyncCDTEditor.this.doSave((IProgressMonitor)new NullProgressMonitor());
                    SyncCDTEditor.this.syncCpp.syncCDTtoModel();
                }
            }

            public void focusGained(FocusEvent e) {
            }
        };
        viewer.getTextWidget().addFocusListener(this.focusListener);
        return viewer;
    }

    public void gotoElement(NamedElement element) {
        ICElement ice = CDTUITools.getEditorInputCElement((IEditorInput)this.getEditorInput());
        if (ice instanceof ITranslationUnit) {
            ITranslationUnit itu = (ITranslationUnit)ice;
            ICElement icElement = ObtainICElement.getICElement(this.syncCpp.getCodeGen(), (IParent)itu, element);
            if (icElement instanceof ISourceReference) {
                try {
                    ISourceRange range = ((ISourceReference)icElement).getSourceRange();
                    ISourceViewer viewer = this.getSourceViewer();
                    viewer.revealRange(range.getStartPos(), 1);
                    viewer.setSelectedRange(range.getStartPos(), range.getLength());
                    return;
                }
                catch (CoreException e) {
                    Activator.log.error((Throwable)e);
                }
            }
        }
    }

    public void dispose() {
        StyledText st = this.getSourceViewer().getTextWidget();
        if (st != null && this.focusListener != null) {
            st.removeFocusListener(this.focusListener);
        }
        if (this.lifeCycleEvents != null) {
            this.lifeCycleEvents.removeAboutToDoSaveListener(this.preSaveEvent);
        }
    }
}

