/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.model2doc.emf.structure2document.generator.helpers;

import org.eclipse.papyrus.model2doc.core.generatorconfiguration.IDocumentGeneratorConfiguration;
import org.eclipse.papyrus.model2doc.core.transcriber.Transcriber;
import org.eclipse.papyrus.model2doc.core.transcription.Transcription;
import org.eclipse.papyrus.model2doc.emf.documentstructure.TextDocument;
import org.eclipse.papyrus.model2doc.emf.structure2document.Activator;
import org.eclipse.papyrus.model2doc.emf.structure2document.generator.helpers.ITranscriptionFactory;
import org.eclipse.papyrus.model2doc.emf.structure2document.generator.transcriber.StructureToTranscriber;

public class CreateFileFromTextDocumentHelper {
    private ITranscriptionFactory transcriptionFactory;
    private TextDocument textDocument;

    public CreateFileFromTextDocumentHelper(TextDocument textDocument, ITranscriptionFactory transcriptionFactory) {
        this.textDocument = textDocument;
        this.transcriptionFactory = transcriptionFactory;
    }

    public String generate() {
        if (this.textDocument == null) {
            Activator.log.warn("The TextDocument is null");
            return null;
        }
        IDocumentGeneratorConfiguration ddgc = this.textDocument.getDocumentGeneratorConfiguration();
        Transcription transcription = this.transcriptionFactory.createTranscription(ddgc);
        Transcriber t = this.createTranscriber(this.textDocument, transcription);
        return this.transcriptionFactory.createFileURI(t.transcribe());
    }

    protected Transcriber createTranscriber(TextDocument textDocument, Transcription transcription) {
        return new StructureToTranscriber(textDocument, transcription);
    }
}

