/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tea.core;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.tea.core.internal.TaskProgressEstimationService;
import org.eclipse.tea.core.internal.model.TaskingModel;
import org.eclipse.tea.core.services.TaskProgressTracker;

public class BackgroundTask {
    private static final ExecutorService backgroundTasks = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors());
    private final Object task;
    private Future<IStatus> future;
    private static final TaskProgressTracker EMPTY_PROGRESS_TRACKER = new TaskProgressTracker(){

        @Override
        public void worked(int amount) {
        }

        @Override
        public boolean isCanceled() {
            return false;
        }

        @Override
        public void setTaskName(String name) {
        }
    };

    public BackgroundTask(Object task) {
        Object actualTask;
        if (task instanceof Class) {
            try {
                actualTask = ((Class)task).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                throw new IllegalStateException("Cannot create task " + String.valueOf(task));
            }
        } else {
            actualTask = task;
        }
        this.task = actualTask;
    }

    @Execute
    public void run(IEclipseContext context) throws Exception {
        this.future = backgroundTasks.submit(() -> {
            IEclipseContext taskCtx = context.createChild();
            ContextInjectionFactory.invoke((Object)this.task, Execute.class, (IEclipseContext)context);
            return (IStatus)taskCtx.get(IStatus.class);
        });
    }

    public Object barrier() {
        return new Object(){

            @Execute
            public Object doWait(TaskProgressEstimationService progressService, TaskProgressTracker rootTracker) throws Exception {
                String estimationId = progressService.calculateId(BackgroundTask.this.task);
                if (estimationId != null) {
                    progressService.begin(estimationId, EMPTY_PROGRESS_TRACKER);
                }
                Future<?> ticker = BackgroundTask.tickProgressTracker(rootTracker, this.getWork(progressService));
                IStatus taskStatus = BackgroundTask.this.future.get();
                if (estimationId != null) {
                    progressService.finish(estimationId, taskStatus);
                }
                ticker.cancel(true);
                return taskStatus;
            }

            public String toString() {
                return "Wait for: " + BackgroundTask.this.toString();
            }

            @TaskProgressTracker.TaskProgressProvider
            public int getWork(TaskProgressEstimationService progressService) {
                String estimationId = progressService.calculateId(BackgroundTask.this.task);
                return estimationId == null ? 1 : progressService.getEstimatedTicks(estimationId);
            }
        };
    }

    public static Object allBarrier(List<Object> tasks) {
        final ArrayList<BackgroundTask> toAwait = new ArrayList<BackgroundTask>();
        int hash = 0;
        for (Object task : tasks) {
            if (!(task instanceof BackgroundTask)) continue;
            toAwait.add((BackgroundTask)task);
            hash ^= ((BackgroundTask)task).task.getClass().getName().hashCode();
        }
        if (toAwait.isEmpty()) {
            return null;
        }
        final String estimationId = "await_async_" + tasks.size() + "_" + hash;
        return new Object(){

            @Execute
            public void doWaitAll(IEclipseContext context, TaskProgressTracker tracker, TaskProgressEstimationService progressService) throws Exception {
                Future<?> ticker = BackgroundTask.tickProgressTracker(tracker, this.getWork(progressService));
                progressService.begin(estimationId, EMPTY_PROGRESS_TRACKER);
                int severity = 0;
                for (BackgroundTask bt : toAwait) {
                    severity |= bt.future.get().getSeverity();
                }
                progressService.finish(estimationId, (IStatus)new Status(severity, "org.eclipse.tea.core", "Finished waiting for background tasks."));
                ticker.cancel(true);
            }

            public String toString() {
                return "Await unfinished background tasks.";
            }

            @TaskProgressTracker.TaskProgressProvider
            public int getWork(TaskProgressEstimationService progressService) {
                return progressService.getEstimatedTicks(estimationId);
            }
        };
    }

    private static Future<?> tickProgressTracker(TaskProgressTracker rootTracker, long estimationTicks) {
        int resolution = 100;
        return backgroundTasks.submit(() -> {
            long remaining = estimationTicks;
            while (remaining > 0L) {
                try {
                    Thread.sleep(resolution);
                }
                catch (InterruptedException e) {
                    return;
                }
                rootTracker.worked(1);
                --remaining;
            }
        });
    }

    public String toString() {
        return TaskingModel.getTaskName(this.task) + " (parallel)";
    }
}

