/*
 * listio.h - QFS listio definitions.
 *
 * Defines the QFS listio input structure and functions.
 *
 */

/*
 *    SAM-QFS_notice_begin
 *
 *      Solaris 2.x Sun Storage & Archiving Management File System
 *
 *		Copyright (c) 2007 Sun Microsystems, Inc. All Rights Reserved.
 *
 *		U.S. Government Rights - Commercial software. Government users are
 *	subject to the Sun Microsystems, Inc. standard license agreement and applicable
 *	provisions of the FAR and its supplements.
 *
 *      	Use is subject to license terms. Sun, Sun Microsystems and the Sun logo
 *	are trademarks or registered trademarks of Sun Microsystems, Inc. in the U.S.
 *	and other countries.
 *
 *    SAM-QFS_notice_end
 */

/*
 *	LGPL NOTICE
 *
 *	This library is free software; you can redistribute it and/or
 *	modify it under the terms of the GNU Lesser General Public
 *	License as published by the Free Software Foundation; either
 *	version 2.1 of the License, or (at your option) any later version.
 *
 *	This library is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *	Lesser General Public License for more details.
 *
 *	You should have received a copy of the GNU Lesser General Public
 *	License along with this library; if not, write to the Free Software
 *	Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

/*
 * $Revision$
 */

#ifdef sun
#pragma ident "$Revision$"
#endif


#ifndef	QFS_LISTIO_H
#define	QFS_LISTIO_H

#include <sys/types.h>

#ifdef  __cplusplus
extern "C" {
#endif


typedef int64_t qfs_lio_handle_t;
int qfs_lio_init(qfs_lio_handle_t *hdl);
int qfs_lio_write(
	int fd,
	int mem_list_count, void **mem_addr, size_t *mem_count,
	int file_list_count, offset_t *file_off, offset_t *file_len,
	qfs_lio_handle_t *hdl);
int qfs_lio_read(
	int fd,
	int mem_list_count, void **mem_addr, size_t *mem_count,
	int file_list_count, offset_t *file_off, offset_t *file_len,
	qfs_lio_handle_t *hdl);
int qfs_lio_wait(qfs_lio_handle_t *hdl);

#ifdef  __cplusplus
}
#endif

#endif /* _QFS_LISTIO_H */
