/*
 * attrtoa.c - Convert SAM-FS attributes to ASCII.
 *
 */

/*
 *    SAM-QFS_notice_begin
 *
 *      Solaris 2.x Sun Storage & Archiving Management File System
 *
 *		Copyright (c) 2007 Sun Microsystems, Inc. All Rights Reserved.
 *
 *		U.S. Government Rights - Commercial software. Government users are
 *	subject to the Sun Microsystems, Inc. standard license agreement and applicable
 *	provisions of the FAR and its supplements.
 *
 *      	Use is subject to license terms. Sun, Sun Microsystems and the Sun logo
 *	are trademarks or registered trademarks of Sun Microsystems, Inc. in the U.S.
 *	and other countries.
 *
 *    SAM-QFS_notice_end
 */

/*
 *	LGPL NOTICE
 *
 *	This library is free software; you can redistribute it and/or
 *	modify it under the terms of the GNU Lesser General Public
 *	License as published by the Free Software Foundation; either
 *	version 2.1 of the License, or (at your option) any later version.
 *
 *	This library is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *	Lesser General Public License for more details.
 *
 *	You should have received a copy of the GNU Lesser General Public
 *	License along with this library; if not, write to the Free Software
 *	Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#pragma ident "$Revision$"


/* Feature test switches. */
	/* None. */

/* ANSI C headers. */
	/* None. */

/* POSIX headers. */
#include <sys/types.h>

/* Solaris headers. */
	/* None. */

/* SAM-FS headers. */
#ifdef	linux
#include "sam/linux_types.h"
#endif	/* linux */
#include "pub/stat.h"

/* Local headers. */
	/* None. */

/* Macros. */
	/* None. */

/* Types. */
	/* None. */

/* Structures. */
	/* None. */

/* Private data. */
	/* None. */

/* Private functions. */
	/* None. */

/* Public data. */
	/* None. */

/* Function macros. */
	/* None. */

/* Signal catching functions. */
	/* None. */


/*
 *	Return attributes in ASCII from attribute field.
 */
char *			/* String returned */
sam_attrtoa(
int attr,		/* Attributes field */
char *string)		/* If not NULL, place string here */
{
	static char s[24];

	if (string == NULL)  string = s;
	string[0] = '-';
	if (SS_ISOFFLINE(attr)) {
		string[0] = (SS_ISPARTIAL(attr)) ? 'P' : 'O';
	}
	if (SS_ISDAMAGED(attr))  string[0] = 'E';

	/*
	 * Archive
	 */
	string[1] = (SS_ISARCHIVE_N(attr)) ? 'n' : '-';
	string[2] = (SS_ISARCHIVE_A(attr)) ? 'a' : '-';
	string[3] = (SS_ISARCHIVE_R(attr)) ? 'r' : '-';

	/*
	 * Release
	 */
	string[4] = (SS_ISRELEASE_N(attr)) ? 'n' : '-';
	string[5] = (SS_ISRELEASE_A(attr)) ? 'a' : '-';
	string[6] = (SS_ISRELEASE_P(attr)) ? 'p' : '-';

	/*
	 * Stage
	 */
	string[7] = (SS_ISSTAGE_N(attr)) ? 'n' : '-';
	string[8] = (SS_ISSTAGE_A(attr)) ? 'a' : '-';
	string[9] = ' ';

	string[10] = ' ';

	/*
	 * Checksum & worm attributes
	 */
	string[11] = (SS_ISCSGEN(attr)) ? 'g' : '-';
	string[12] = (SS_ISCSUSE(attr)) ? 'u' : '-';
	string[13] = (SS_ISCSVAL(attr)) ? 'v' : '-';
	string[14] = (SS_ISWORM(attr)) ? 'w' : '-';
	string[15] = (SS_ISREADONLY(attr)) ? 'R' : '-';
	string[16] = ' ';

	/*
	 * Segment attributes
	 */
	string[17] = (SS_ISSEGMENT_A(attr)) ? 's' : '-';
	if (SS_ISSEGMENT_F(attr))  {
		string[18] =  'I';
	} else if (SS_ISSEGMENT_S(attr))  {
		string[18] =  'S';
	} else string[18] = '-';
	string[19] = ' ';

	/*
	 * Access control list attribute
	 */
	string[20] = (SS_ISDFACL(attr)) ? 'D' : '-';
	string[21] = (SS_ISACL(attr)) ? 'A' : '-';
	string[22] = '\0';

	return (string);
}
