/*
 * media.c - Convert between SAM media code and ASCII.
 */

/*
 *    SAM-QFS_notice_begin
 *
 *      Solaris 2.x Sun Storage & Archiving Management File System
 *
 *		Copyright (c) 2007 Sun Microsystems, Inc. All Rights Reserved.
 *
 *		U.S. Government Rights - Commercial software. Government users are
 *	subject to the Sun Microsystems, Inc. standard license agreement and applicable
 *	provisions of the FAR and its supplements.
 *
 *      	Use is subject to license terms. Sun, Sun Microsystems and the Sun logo
 *	are trademarks or registered trademarks of Sun Microsystems, Inc. in the U.S.
 *	and other countries.
 *
 *    SAM-QFS_notice_end
 */

/*
 *	LGPL NOTICE
 *
 *	This library is free software; you can redistribute it and/or
 *	modify it under the terms of the GNU Lesser General Public
 *	License as published by the Free Software Foundation; either
 *	version 2.1 of the License, or (at your option) any later version.
 *
 *	This library is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *	Lesser General Public License for more details.
 *
 *	You should have received a copy of the GNU Lesser General Public
 *	License along with this library; if not, write to the Free Software
 *	Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */
#pragma ident "$Revision$"

#include <string.h>
#include "sam/types.h"
#include "sam/devnm.h"
#include "pub/devstat.h"

/*
 *	Return media name from media type.
 */
char *			/* Media name, empty if not valid */
sam_mediatoa(
int mt)			/* Media type */
{
	char *media_name;
	dev_nm_t   *tmp;

	for (tmp = &dev_nm2mt[0]; tmp->nm != NULL; tmp++) {
		if (mt == tmp->dt) {
			return (tmp->nm);
		}
	}

	/*
	 * Did not find matching media type.  Check for
	 * third party media types.  If not third party,
	 * an empty string is returned.
	 */
	media_name = "";
	if ((mt & DT_CLASS_MASK) == DT_THIRD_PARTY) {
		int n;

		n = mt & DT_MEDIA_MASK;
		if (n >= '0' && n <= '9') {
			media_name = dev_nmtr[n - '0'];
		} else if (n >= 'a' && n <= 'z') {
			media_name = dev_nmtr[(n - 'a') + 10];
		}
	}

	return (media_name);
}


/*
 *	Return media type from media name.
 */
int			/* Media type, 0 if not valid */
sam_atomedia(
char *name)		/* Media name */
{
	dev_nm_t   *tmp;

	for (tmp = &dev_nm2mt[0]; tmp->nm != NULL; tmp++) {
		if (strcmp(name, tmp->nm) == 0) {
			return (tmp->dt);
		}
	}

	return (0);
}
