// Copyright (C) 2016 The Qt Company Ltd.
// SPDX-License-Identifier: LicenseRef-Qt-Commercial

import QtQuick 2.0
import test.RotateValue 1.0

Rectangle {
    id: page

    width: 500; height: 200
    color: "lightgray"
    required property RotateValue rotatevalue

    Rectangle {
        id: button
        width: 150; height: 40
        color: "darkgray"
        anchors.horizontalCenter: page.horizontalCenter
        y: 120
        MouseArea {
            id: buttonMouseArea
            objectName: "buttonMouseArea"
            anchors.fill: parent
            onEntered: {
                    rotatevalue.rotation = rotatevalue.val()
            }
        }
        Text {
            id: buttonText
                text: "Press me!"
            anchors.horizontalCenter: button.horizontalCenter
            anchors.verticalCenter: button.verticalCenter
            font.pointSize: 16;
        }
    }
}
